/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef __V_STATIC_TEXT_H__
#define __V_STATIC_TEXT_H__

#include "v/VObject.h"

class VStaticText : public VObject
{
  public:
	enum { object_type = VO_STXT };
	virtual unsigned	get_type() const { return object_type; }
	
	static VStaticText*	create(const VObjectStatus *s, int flags, VExError *err=0) {
		return create(s, flags, 0, err);
	}
	static VStaticText*	create(const VObjectStatus *s, int flags, void *arg, VExError *err=0) {
		return static_cast<VStaticText*>(
			create_tmp(internal_new, object_type, s, flags, err));
	}
	
	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	redraw(VRect* rect = 0) const;
	
  protected:
	virtual ~VStaticText();
	
	virtual VExError	create_do(const VObjectStatus *, int flags,
					VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);

  private:
	static VObject *internal_new(){
		return new VStaticText();
	}
};

#endif
