/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___GRAPH_H___
#define ___GRAPH_H___


#define GRAPH_INLINE

#define IABS(x)	( (x)< 0 ? -(x) : (x) )
#define IMAX(x,y) ( (x) < (y) ? (y) : (x) )


typedef float REAL1;
//typedef double REAL1;

typedef struct s_point {
	short	x;
	short	y;
} S_POINT;

typedef struct s_rect {
	short	l;
	short	t;
	short	r;
	short	b;
} S_RECT;

typedef struct i_point {
	int	x;
	int	y;
} I_POINT;

typedef struct i_rect {
	I_POINT	tl;
	I_POINT	br;
} I_RECT;


typedef struct r_point {
	REAL1	x;	/* unit = m */
	REAL1	y;
} R_POINT;

typedef struct r_point3d {
	REAL1	x;
	REAL1	y;
	REAL1	z;
} R_POINT3D;

typedef struct r_rect {
	R_POINT		tl;
	R_POINT		br;
} R_RECT;

#define COL_BIT			10
#define COL_MASK		0x3ff

#define C_TRANSPARENT		0x40000000
#define C_DIRTY			0x80000000
#define C_COLOR			0x3fffffff

#define COL(r,g,b)	((r)|((g)<<COL_BIT)|((b)<<(COL_BIT*2)))
#define GET_COL(pix,r,g,b)	\
	(	(r) = (pix)&COL_MASK,			\
		(g) = ((pix)>>COL_BIT)&COL_MASK,		\
		(b) = ((pix)>>(2*COL_BIT))&COL_MASK)
#define BREND_ALPHA(rd,dd,da,sd,sa)	\
		(rd) =						\
			((dd) * (da) * (COL_MASK - (sa)) +	\
				COL_MASK * (sd) * (sa)) /	\
			(COL_MASK * ((da) + (sa)) - (da) * (sa))
#define BREND_ALPHA_A(ra,da,sa)	\
		(ra) = (COL_MASK *((da) + (sa)) - (da)*(sa)) / COL_MASK

#define C_NULL			0x40000000



S_RECT	rect_conv_r2s(R_RECT);
S_RECT	rect_conv_i2s(I_RECT);
void er_panic(char*);
I_POINT p_addi(I_POINT,I_POINT);
void insert_rect_i(I_RECT *,I_POINT);
void marge_vrect(I_RECT * r1,I_RECT * r2);


#endif
