/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<fcntl.h>
#include	"xl.h"
#include	"memory_debug.h"
#include	"acrp.h"



XL_SEXP *
_get_cid_sexp(MAP_PATH_INFO * mpi)
{
int * acrp;
int i;
XL_SEXP * ret;
L_CHAR * pri, * body;
XL_SEXP * cid;
	acrp = _get_cid(&pri,&body,mpi->mpt);
	if ( acrp == 0 )
		return 0;
	ret = 0;
	for ( i = acrp[0] ; i > 0 ; i -- ) {
		ret = cons(get_integer(acrp[i],0),ret);
	}
	d_f_ree(acrp);
	cid = n_get_symbol("cid");
	if ( pri ) {
		set_attribute(cid,
			l_string(std_cm,"pri"),
			pri);
		d_f_ree(pri);
	}
	if ( body ) {
		set_attribute(cid,
			l_string(std_cm,"body"),
			body);
		d_f_ree(body);
	}
	return cons(cid,ret);
}

XL_SEXP *
get_cid_sexp(L_CHAR * filename)
{
int * acrp;
int i;
XL_SEXP * ret;
L_CHAR * pri, * body;
XL_SEXP * cid;
	acrp = get_cid(&pri,&body,filename);
	if ( acrp == 0 )
		return 0;
	ret = 0;
	for ( i = acrp[0] ; i > 0 ; i -- ) {
		ret = cons(get_integer(acrp[i],0),ret);
	}
	d_f_ree(acrp);
	cid = n_get_symbol("cid");
	if ( pri ) {
		set_attribute(cid,
			l_string(std_cm,"pri"),
			pri);
		d_f_ree(pri);
	}
	if ( body ) {
		set_attribute(cid,
			l_string(std_cm,"body"),
			body);
		d_f_ree(body);
	}
	return cons(cid,ret);
}


XL_SEXP *
_get_cid_sexp_fast(L_CHAR * filename)
{
XL_SEXP * ret, * cid;
STREAM * st;

URL u;
L_CHAR * _filename;
MAP_PATH_TABLE * mpt;
unsigned int reg;
int cid_flag;
int * acrp;
L_CHAR * pri,* body;
int i;

	get_url2(&u,filename);
	_filename = get_access_path(&u,".mpt");

	st = s_open_file(n_string(std_cm,_filename),O_RDONLY);
	if ( st == 0 ) {
		ret = 0;
		goto end;
	}

	ret = init_parse(st,_filename,_filename);

	switch ( get_type(ret) ) {
	case XLT_ERROR:
	case XLT_NULL:

		ret = 0;
		goto end;
	case XLT_PAIR:
		break;
	default:
		ret = 0;
		goto end;
	}
	ret = get_el(ret,1);
	cid = get_el_by_symbol(ret,
			l_string(std_cm,"cid"),
			0);
	if ( get_type(cid) == XLT_PAIR )
		return cid;
	else {
		mpt = get_mpt(&reg,&cid_flag,ret);
		acrp = _get_cid(&pri,&body,mpt);
		if ( acrp == 0 )
			return 0;
		ret = 0;
		for ( i = acrp[0] ; i > 0 ; i -- ) {
			ret = cons(get_integer(acrp[i],0),ret);
		}
		d_f_ree(acrp);
		cid = n_get_symbol("cid");
		if ( pri ) {
			set_attribute(cid,
				l_string(std_cm,"pri"),
				pri);
			d_f_ree(pri);
		}
		if ( body ) {
			set_attribute(cid,
				l_string(std_cm,"body"),
				body);
			d_f_ree(body);
		}
		return cons(cid,ret);
	}
end:
	d_f_ree(_filename);
	return ret;
}

XL_SEXP *
get_cid_sexp_fast(L_CHAR * filename)
{
XL_SEXP * ret;
void gc_gb_sexp();
XL_SEXP * r;
	gc_push(0,0,"get_cid_sexp_fast");
	ret = _get_cid_sexp_fast(filename);
	for ( r = ret ; get_type(r) == XLT_PAIR ; r = cdr(r) );
	gc_pop(ret,gc_gb_sexp);
	if ( get_type(ret) != XLT_PAIR )
		return ret;
	return get_cid_sexp(filename);
}


