/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_TYPES_H___
#define ___V_TYPES_H___

#include	"graph.h"
#include	"long_char.h"

#include	"v/v_graph.h"

typedef struct verror {
	int		err1;
	int		err2;
} VERROR;

typedef struct vtext_ind {
	int					mode;
#define VT_TRANS			1
#define VT_BACKGROUND		2
	LC_WRITING_STYLE *	ws;
 	int					size;
	int					dir;
	int					st_x;
	int					st_y;
	L_CHAR *			data;
	int					length;
	unsigned long		color;
	unsigned long		background;
	VRECT				minrect;
} VTEXT_IND;


#define NeedFunctionPrototypes 1

#ifdef __cplusplus
typedef class CLEMWindow *	Window;
typedef class LGWorld *		Image;
#else
typedef void * Window;
typedef void * Image;
#endif

#include	"machine/msequence.h"

//--------------------------------------------------------------------------
#pragma mark	VOBJECT
//--------------------------------------------------------------------------

typedef struct vobj_header {
	int			type;
	union vobject *		next;
	struct vwindow *	win;
	void			(*handler)(/* obj, cmd, ...*/);
	/* cmd */
#define VE_REDRAW	1
#define VE_BUTTON		2
#define VE_MAX		3

#define VES_BUTTON_PRESS		1
#define VES_BUTTON_RELEASE	2
#define VES_BUTTON_MOTION		3
} VOBJ_HEADER;

typedef struct vimage {
	VOBJ_HEADER		_h;
	char *			buf_8;
	short *			buf_16;
	long *			buf_32;
	int				x;
	int				y;
	int				w;
	int				h;
	int				w_border;

	int				select_flag;
		/* 1 --> select */
		/* 0 --> not select */
	VPOINT			select[2];
	
	Image			image;
} VIMAGE;

typedef struct vtext {
	VOBJ_HEADER		_h;
	VTEXT_IND		in;
} VTEXT;

typedef union vobject {
	VOBJ_HEADER	header;
#define VT_IMAGE	1
#define VT_TEXT	2
	VIMAGE		vimage;
	VTEXT		vtext;
} VOBJECT;


//--------------------------------------------------------------------------
#pragma mark	VDISPLAY
//--------------------------------------------------------------------------

typedef struct v_map_tbl {
/*	unsigned int *		map[3];
#define GB2M_R	0
#define GB2M_G	1
#define GB2M_B	2
*/
	int			pixel_bits;

	char			red_shift;
	char			green_shift;
	char			blue_shift;
	char			color_bit;
	unsigned long		red_mask;
	unsigned long		green_mask;
	unsigned long		blue_mask;
} V_MAP_TBL;

/*
typedef struct vfont_list {
    char *      name;
	short		id;
    int 	    size;
} VFONT_LIST;
*/

typedef struct vfont {
    Str255			fontname;
    ScriptCode		script;
    FMFontFamily	id;
    short			default_size;
} VFONT;

typedef struct vdisplay {
	/* machine indipendent members */

	int			(*err_handler)();
	struct vwindow *	win_list;
	void			(*handler[VE_MAX])();
	WCT *			wct;

	/* machine dipendent members */

	struct vdisplay *	next;
	V_MAP_TBL		gb2m_map;

	int			depth;

	LC_FONT_ENGINE          fe;
} VDISPLAY;

#define GB2MCOLOR(tbl,f)							\
		(((((unsigned long)(f))&COL_MASK)				\
			>>(COL_BIT-(tbl).color_bit)					\
			<<(tbl).red_shift)&(tbl).red_mask) |			\
		((((((unsigned long)(f))>>COL_BIT)&COL_MASK)		\
			>>(COL_BIT-(tbl).color_bit)					\
			<<(tbl).green_shift)&(tbl).green_mask) |		\
		((((((unsigned long)(f))>>COL_BIT*2)&COL_MASK)	\
			>>(COL_BIT-(tbl).color_bit)					\
			<<(tbl).blue_shift)&(tbl).blue_mask)

#define GB2MCOLOR_D(d,f)	GB2MCOLOR(d->gb2m_map,f)

#define MCOLOR2GB(r,g,b,tbl,f)					\
	{										\
		(r) = ((((unsigned long)(f))&(tbl).red_mask)		\
			>>(tbl).red_shift)						\
			<<(COL_BIT-(tbl).color_bit);				\
		(g) = ((((unsigned long)(f))&(tbl).green_mask)	\
			>>(tbl).green_shift)					\
			<<(COL_BIT-(tbl).color_bit);				\
		(b) = ((((unsigned long)(f))&(tbl).blue_mask)		\
			>>(tbl).blue_shift)					\
			<<(COL_BIT-(tbl).color_bit);				\
	}

#define GB2RGB_M(f,n)	\
	(((f)>>COL_BIT*(n))&COL_MASK)<<(16-COL_BIT)

#define GB2RGB(f,rgb)	\
	{							\
	(rgb).red		= GB2RGB_M(f,0);	\
	(rgb).green	= GB2RGB_M(f,1);	\
	(rgb).blue		= GB2RGB_M(f,2);	\
	}

extern const RGBColor RGB_black, RGB_white;

//--------------------------------------------------------------------------
#pragma mark	VWINDOW
//--------------------------------------------------------------------------

typedef struct vwindow {
	struct vwindow *	next;
	VOBJECT *		obj_list;

	VDISPLAY *		d;
	Window			w;
} VWINDOW;

typedef struct vwindow_attributes {
	int			x;
	int			y;
	int			w;
	int			h;
} VWINDOW_ATTRIBUTES;

VWINDOW * _get_vwin(VDISPLAY *,Window);

//#define CB_MACHINE_ORDER	CB_MSB_FIRST

/* errors */
#ifndef E_OK
#define E_OK		0
#define E_SYS		(-1)
#endif
#define E_VMATCH	(-2)
#define E_PARAM		(-3)

VDISPLAY *
v_open_disp(VERROR * err);

VWINDOW *
v_open_win(VERROR * err,VDISPLAY * d,int x,int y,int w,int h);
void
v_get_window_attributes(VERROR *,VWINDOW_ATTRIBUTES *,VWINDOW *);
void v_clear_window_content(VERROR * err, VWINDOW *win);

VOBJECT *
v_create_image(VERROR * err,VWINDOW * win,int x,int y,int w,int h);
void
v_set_image(VERROR * err,VOBJECT * obj,int x,int y,int w,int h);
int
v_image_minrect(VRECT * ,VOBJECT *);
void *
v_get_and_new_image(int *,VOBJECT *);

VOBJECT *
v_create_text(VERROR * err,VWINDOW * win,
		unsigned long,unsigned long,
	    	LC_WRITING_STYLE *,
		int,int,
		int,int,L_CHAR*,int);
int
v_set_text(VERROR *,VOBJECT *,
		unsigned long,unsigned long,
		LC_WRITING_STYLE *,
		L_CHAR *,int);
void
v_move_text(VOBJECT *,int,int);
int
v_text_minrect(VRECT*,VOBJECT*);

int check_inside(VRECT,VPOINT);

void
v_get_string_pic(
	LC_STRING_PIC * p,
	int 		dir,
	LCF_SET *	str,
	int len);

int
v_select_box(VOBJECT * obj,VPOINT st,VPOINT end,int flag);

void
marge_vrect(VRECT *,VRECT *);

void
v_set_display_key(char *);

extern void (*null_handler)();
extern void (*invoke_handler)();

LC_FONT_ENGINE *v_get_font_engine(VOBJECT * );


/* NEW */

int
v_get_font(LC_FONT * f,LC_FONT_ENGINE * fe);
void v_get_string_pic_call(
        LC_STRING_PIC * p,
        VDISPLAY * disp,
        LCF_SET * str,
        int len,
        short id,
        short script,
        int     size,
        int     dir,
        L_CHAR mask);
void compose_pic(LC_STRING_PIC * p,LC_STRING_PIC * pp);
int _v_redraw_image(void * arg);
void v_image_handler(
	VOBJECT *	obj,
	int		cmd);
void v_scroll_image(VOBJECT * obj,int dx,int dy);
int _v_get_and_new_image(void * arg);
void new_v_loop(TKEY d);
int set_gb2m(unsigned int * table);
void set_gb2m_mask_and_shift(V_MAP_TBL * tbl, short color_bit);
void v_draw_text_one_font_8(
	VRECT * r,
	VOBJECT * obj,
	VPOINT * st,
	char * str,
	int len,
	short id,
	short size);
char * convert_8(LCF_SET * str,int len);
char * convert_7(LCF_SET * str,int len);
char * convert_16(LCF_SET * str,int *len);
void v_draw_text_one_font(
	VRECT * r,
	VOBJECT * obj,
	VPOINT * st,
	LCF_SET * str,
	int len,
	VFONT * vf,
	int size,
	L_CHAR mask);
void v_draw_text(VOBJECT * obj);
int _v_redraw_text(VOBJECT*args);
void v_redraw_text(VTEXT * vt);
void v_text_handler(
	VOBJECT *	obj,
	int		cmd);
int _v_set_text(void * args);
int _v_text_minrect(void *args);




#endif
