/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	"utils.h"
#include	"memory_debug.h"

#define BUFFER_FIFO_SIZE		50
#define BUFFER_THREAD_LEN		11

typedef struct buffer {
	THREAD_AREA_HEADER	h;
	int			ptr;
	void *			fifo[BUFFER_FIFO_SIZE];
} BUFFER;

THREAD_AREA	sb_ta;

void
set_buffer_close_gc(BUFFER * bf)
{
int i;
	for ( i = 0 ; i < BUFFER_FIFO_SIZE ; i ++ )
		if ( bf->fifo[i] )
			d_f_ree(bf->fifo[i]);
}

void
init_set_buffer()
{
THREAD_AREA param;
	param.ent_size = BUFFER_THREAD_LEN;
	param.area_size = sizeof(BUFFER);
	param.close_gc = set_buffer_close_gc;
	init_thread_area(&sb_ta,&param);
}

void
set_buffer(void * buf)
{
BUFFER * bf;
	init_set_buffer();
	bf = get_my_area(&sb_ta);
	if ( bf->fifo[bf->ptr] )
		d_f_ree(bf->fifo[bf->ptr]);
	bf->fifo[bf->ptr] = buf;
	bf->ptr ++;
	if ( bf->ptr >= BUFFER_FIFO_SIZE )
		bf->ptr = 0;
}
