/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___PMD_H___
#define ___PMD_H___

#include	"pdb.h"
#include	"resource.h"
#include	"xl.h"

#define PMD_LIMIT	60

typedef struct acc_pn_pmd_header {
	ACC_HEADER		h;
	PN_PMD_HEADER		d;
} ACC_PN_PMD_HEADER;

typedef struct acc_pn_pmd_node {
	ACC_HEADER		h;
	PN_PMD_NODE		d;
} ACC_PN_PMD_NODE;

typedef struct acc_pn_pmd_md {
	ACC_HEADER		h;
	PN_PMD_MD		d;
} ACC_PN_PMD_MD;

typedef struct acc_pn_pmd_ofslist {
	ACC_HEADER		h;
	PN_PMD_OFSLIST		d;
} ACC_PN_PMD_OFSLIST;

typedef struct pmd_work {
	int			err;
	char * 			path;
	PDB *			p;
	ACC_PN_PMD_HEADER	pmd_h;
	CALL_LOCK_DESCRIPTER	lock_id;
} PMD_WORK;

typedef struct pmd_temp {
	unsigned int	fofs;
	GB_RECT		minrect;
	REAL1		resolution;
	GB_TIME		content_period_from;
	GB_TIME		content_period_to;
	unsigned int	timeout;
	unsigned int	md_fofs;
	BIB_LIST *	md_list;
	unsigned short	category;
	L_CHAR * 	crd;
	L_CHAR * 	target;
} PMD_TEMP;

typedef struct pmd_temp_list {
	struct pmd_temp_list *	next;
	PMD_TEMP *		temp;
} PMD_TEMP_LIST;

#define WRITE_TEMP_ALLOC	1
#define WRITE_TEMP_UPDATE	2

void open_db(PMD_WORK * w,L_CHAR * db,L_CHAR * unit_path,int mode);
void close_db(PMD_WORK * w);
unsigned int search_db_by_target(PMD_WORK * w,L_CHAR * crd,L_CHAR * obj);
PMD_TEMP * 
get_temp_resource(RESOURCE * r,
	L_CHAR *crd,
	GB_RECT * minrect,
	REAL1 resolution);
unsigned int write_temp(PMD_WORK * w,PMD_TEMP * t,int type);
int insert_db(PMD_WORK * w,PMD_TEMP * t);
int cmp_temp(PMD_TEMP * t1,PMD_TEMP * t2);
int change_timeout(PMD_WORK * w,PMD_TEMP * t,unsigned int timeout);
int delete_db(PMD_WORK * w,PMD_TEMP * t);
PMD_TEMP * get_temp_db(PMD_WORK * w,unsigned int fofs);
void free_temp(PMD_TEMP *);
void *
maxmin_ix(
	int * d_len,
	PMD_WORK * w,
	unsigned int root,
	void (*endian_func)(),
	int (*trace_func)());
void get_db_status(PMD_WORK * w,PMD_TEMP * min,PMD_TEMP * max);
PMD_TEMP_LIST *
query_db(PMD_WORK * 	w,
	GB_RECT* 	rect,
	REAL1		reso_min,
	REAL1		reso_max);

#endif
