/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdio.h>
#include	<sys/types.h>
#include	<winsock2.h>

#include	"memory_debug.h"
#include	"machine/err.h"
#include	<stdlib.h>
#include	"server.h"

int accept_test;
int accept_tid;


extern int now_open_files;

ACCESS_KEY *
accept_connection(STREAM * sd)
{
int len2;
int id;
struct sockaddr_in client;
ACCESS_KEY * key;
extern S_TABLE s_socket_table, s_accept_table;
extern void _s_open(STREAM * s,int mode);

	if ( sd->h.tbl != &s_accept_table )
		return 0;
	len2 = sizeof(client);
	for ( ; ; ) {
		if ((id = accept(sd->accept.fid, (struct sockaddr*)&client, &len2)) == -1) {
			if ( errno != ESYS_AGAIN ) {
				printf("Error(server): can't accept\n");
				perror("");
				return 0;
			}
			continue;
		}
		break;
	}
	key = d_alloc(sizeof(*key));
	key->s = d_alloc(sizeof(S_SOCKET));
	key->s->h.tbl = &s_socket_table;
	key->s->socket.sock = id;
	_s_open(key->s,O_RDWR);
	now_open_files ++;
	key->ip = ntohl(client.sin_addr.s_addr);
	key->work = 0;
	
	printf("accept connection\n");
	return key;
}

