/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	"memory_debug.h"
#include	"xl.h"
#include	"xlerror.h"

/*
(shell "command" "argment" ....)
*/

XL_SEXP * 
gb_shell(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * a;
XL_SEXP * b;
L_CHAR * cmd;
int len,len2;
int cnt;
	cmd = d_alloc(sizeof(L_CHAR));
	cmd[0] = 0;
	len = 0;
	cnt = 1;
	for ( a = cdr(s) ; get_type(a) ; a = cdr(a) , cnt ++ ) {
		b = eval(env,car(a));
		switch ( get_type(b) ) {
		case XLT_ERROR:
			return b;
		case XLT_STRING:
			break;
		default:
			goto typemissmatch;
		}
		len2 = l_strlen(b->string.data);
		cmd = d_re_alloc(cmd,(len+len2+1)*sizeof(L_CHAR));
		l_strcpy(&cmd[len],b->string.data);
		len += len2;
	}
	launch_proc_stdio(0,0,0,n_string(std_cm,cmd));
	d_f_ree(cmd);
	return 0;
typemissmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"shell"),
		list(	n_get_string("type missmatch at argment "),
			get_integer(cnt,0),
			0));
}
