/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	"xl.h"
#include	"gbview.h"
#include	"memory_debug.h"
#include	"memory_routine.h"


GB_PALETTE default_palette ={
	{0x3ff,1},
	{0x3ff,1}
};


int
cmp_obj_code(OBJ * o1,OBJ * o2)
{
	if ( o1->h.code < o2->h.code )
		return -1;
	if ( o1->h.code > o2->h.code )
		return 1;
	return 0;
}

int
insert_code_tree(RESOURCE * r,OBJ * o)
{
AVT_NODE * a1, * a2;

	touch_obj_mem(sizeof(*a1)); 
	a1 = d_alloc(sizeof(*a1));
	a1->data = o;
	a2 = avt_insert(&r->draw_gb.obj_code_tree,a1,cmp_obj_code);
	if ( a1 == a2 )
		return 0;
	d_f_ree(a1);
	touch_obj_mem(-sizeof(*a1));
	return -1;
}


OBJ *
new_object(
	RESOURCE *r,
	int type,
	unsigned int code)
{
OBJ * o;
OBJ * o1;
	if ( r->h.type != RT_DRAW_GB )
		return 0;
	touch_obj_mem(sizeof(*o));
	o = d_alloc(sizeof(*o));
	o->h.code = code;
	o->h.type = type;
	o->h.palette = default_palette;
	o->h.info_org = 0;
	o->h.info_card = 0;
	o->h.info_onmap = 0;
	o->h.name = 0;
	o->h.flags = 0;
	o->h.minrect.tl.x = o->h.minrect.tl.y = 0;
	o->h.minrect.br.x = o->h.minrect.br.y = -1;
	o->h.onmap_resolution = 0;
	o->h.req_resolution = 0;
	o->h.lod_min = -1;
	o->h.lod_max = -1;
	if ( insert_code_tree(r,o) < 0 )
		er_panic("new_object");
	return o;
}
