/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"resource.h"


extern RESOURCE ** res_entry_hash_table;
extern RESOURCE ** res_target_hash_table;
extern RESOURCE ** res_no_hash_table;
extern SEM res_lock;

RESOURCE *
_search_resource_by_entry(URL * u)
{
RESOURCE * ret;
int key;
	key = get_rhash_key(u);
	for ( ret = res_entry_hash_table[key]; 
			ret ;
			ret = ret->h.entry_next ) {
		if ( url_cmp_str(&ret->h.entry,u) == 0 )
			return ret;
	}
	return 0;
}

RESOURCE *
search_resource_by_entry(URL * u)
{
RESOURCE * ret;
	lock_task(res_lock);
	ret = _search_resource_by_entry(u);
	unlock_task(res_lock,"search_resource_by_entry");
	return ret;
}


RESOURCE *
_search_resource_by_target(URL * u)
{
RESOURCE * ret;
int key;
	key = get_rhash_key(u);
	for ( ret = res_target_hash_table[key] ;
			ret;
			ret = ret->h.target_next ) {
		if ( url_cmp_str(&ret->h.target,u) == 0 )
			return ret;
	}
	return 0;
}

RESOURCE *
search_resource_by_target(URL * u)
{
RESOURCE * ret;
	lock_task(res_lock);
	ret = _search_resource_by_target(u);
	unlock_task(res_lock,"search_resource_by_target");
	return ret;
}


RESOURCE *
_search_resource_by_no(int no)
{
RESOURCE * ret;
int key;
	key = ((unsigned int)no) % RES_HASH_SIZE;
	for ( ret = res_no_hash_table[key] ;
			ret;
			ret = ret->h.no_next ) {
		if ( ret->h.no == no )
			return ret;
	}
	return 0;
}

RESOURCE *
search_resource_by_no(int no)
{
RESOURCE * ret;
	lock_task(res_lock);
	ret = _search_resource_by_no(no);
	unlock_task(res_lock,"search_resource_by_no");
	return ret;
}

