/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	<string.h>
#include	<Shlobj.h>
#include	"utils.h"
#include	"memory_debug.h"

static char * preference_path;
static char * peripheral_path;
char xlpconf[] = "pxlconf\\";
char gvperipheral[] = "peripheral\\";

char * command_arg;

char *
get_preference_path()
{
	if(preference_path)
		return preference_path;
	{
		int len, len2;
		char *buf;
		LPITEMIDLIST pIDList;
		char pszPath[MAX_PATH+1];

		if(SUCCEEDED(SHGetSpecialFolderLocation(NULL, CSIDL_PERSONAL, &pIDList))){
			SHGetPathFromIDList(pIDList, pszPath);
			CoTaskMemFree(pIDList);
		}
		
		len = strlen(pszPath);
		len2 = strlen(xlpconf);
		
		buf = d_alloc(len+len2+2);
		strcpy(buf,pszPath);
		if ( buf[len-1] != '\\' ) {
			buf[len] = '\\';
			buf[len+1] = 0;
		}
		strcat(buf, xlpconf);
		preference_path = normalize_delim_str(buf);
		if ( buf != preference_path )
			d_f_ree(buf);
		return preference_path;
	}
}




char *
get_peripheral_path()
{
char pszAppFile[MAX_PATH+1];
char pszAppPath[MAX_PATH+1];
char *p;
char *buf;

	if ( peripheral_path )
		return peripheral_path;
	GetModuleFileName(GetModuleHandle(NULL), pszAppFile, MAX_PATH);
	p = strrchr(pszAppFile, '\\')+1;
	strncpy(pszAppPath, pszAppFile, p-pszAppFile);
	pszAppPath[p-pszAppFile] = '\0';
	strcat(pszAppPath, gvperipheral);
	buf = d_alloc(strlen(pszAppPath) + 11);
	strcpy(buf, pszAppPath);

	peripheral_path = normalize_delim_str(buf);
	if ( buf != peripheral_path )
		d_f_ree(buf);
	return peripheral_path;
}



