/*
 * Decompiled with CFR 0.152.
 */
package net.twoch.GikoMail;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;
import net.twoch.GikoMail.Constant;
import net.twoch.GikoMail.Desktop;
import net.twoch.GikoMail.MailFormat;
import net.twoch.GikoMail.MailTokenizer;
import net.twoch.GikoMail.ReplyMail;
import net.twoch.GikoMail.WindowsManager;

public class MailShow
extends JInternalFrame
implements ActionListener {
    public static final Border loweredBorder = new SoftBevelBorder(1);
    public static final Dimension dd = new Dimension(200, 25);
    String filename;
    String maildata;
    MailFormat mf;
    JButton replyBtn;
    JButton allReplyBtn;

    MailShow(String string, String string2) {
        this.setTitle(string2);
        this.setBounds(WindowsManager.getx(), WindowsManager.gety(), 600, 600);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.setResizable(true);
        Font font = new Font("MS Gothic", 1, 14);
        this.filename = string;
        if (!this.readMailFromFile()) {
            return;
        }
        JScrollPane jScrollPane = new JScrollPane(22, 32);
        jScrollPane.setSize(600, 400);
        JPanel jPanel = this.buildPanel();
        jScrollPane.getViewport().add(jPanel);
        this.getContentPane().add((Component)jScrollPane, "Center");
        JToolBar jToolBar = new JToolBar();
        this.buildMenubar(jToolBar);
        this.getContentPane().add((Component)jToolBar, "North");
    }

    private void buildMenubar(JToolBar jToolBar) {
        this.replyBtn = new JButton("\u8fd4\u4fe1");
        this.replyBtn.addActionListener(this);
        jToolBar.add(this.replyBtn);
        this.allReplyBtn = new JButton("\u5168\u54e1\u306b\u8fd4\u4fe1");
        this.allReplyBtn.addActionListener(this);
        jToolBar.add(this.allReplyBtn);
    }

    public boolean readMailFromFile() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        String string = Constant.FILE_DIRECTORY + this.filename + "." + "mxm";
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((object = bufferedReader.readLine()) != null) {
                stringBuffer.append((String)object + "\r\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
            return false;
        }
        object = new MailTokenizer(stringBuffer);
        this.mf = ((MailTokenizer)object).getMail();
        this.maildata = new String(stringBuffer);
        return true;
    }

    protected JPanel buildPanel() {
        JTextField[] jTextFieldArray = new JTextField[6];
        JPanel jPanel = MailShow.createVerticalPanel(true);
        JPanel jPanel2 = MailShow.createHorizontalPanel(false);
        JPanel jPanel3 = MailShow.createHorizontalPanel(false);
        JPanel jPanel4 = MailShow.createHorizontalPanel(false);
        JPanel jPanel5 = MailShow.createHorizontalPanel(false);
        JPanel jPanel6 = MailShow.createHorizontalPanel(false);
        JPanel jPanel7 = MailShow.createHorizontalPanel(false);
        BorderedSetLabel borderedSetLabel = new BorderedSetLabel("To:");
        jPanel2.add(borderedSetLabel);
        jTextFieldArray[0] = new BorderedSwingSetText(this.mf.to);
        jTextFieldArray[0].setHorizontalAlignment(2);
        jPanel2.add(jTextFieldArray[0]);
        borderedSetLabel = new BorderedSetLabel("From:");
        jPanel3.add(borderedSetLabel);
        jTextFieldArray[1] = new BorderedSwingSetText(this.mf.from);
        jTextFieldArray[1].setHorizontalAlignment(2);
        jPanel3.add(jTextFieldArray[1]);
        borderedSetLabel = new BorderedSetLabel("Subject:");
        jPanel4.add(borderedSetLabel);
        jTextFieldArray[2] = new BorderedSwingSetText(this.mf.subject);
        jTextFieldArray[2].setHorizontalAlignment(2);
        jPanel4.add(jTextFieldArray[2]);
        borderedSetLabel = new BorderedSetLabel("Cc:");
        jPanel5.add(borderedSetLabel);
        jTextFieldArray[3] = new BorderedSwingSetText(this.mf.cc);
        jTextFieldArray[3].setHorizontalAlignment(2);
        jPanel5.add(jTextFieldArray[3]);
        borderedSetLabel = new BorderedSetLabel("Bcc:");
        jPanel6.add(borderedSetLabel);
        jTextFieldArray[4] = new BorderedSwingSetText(this.mf.bcc);
        jTextFieldArray[4].setHorizontalAlignment(2);
        jPanel6.add(jTextFieldArray[4]);
        borderedSetLabel = new BorderedSetLabel("Attachment:");
        jPanel7.add(borderedSetLabel);
        jTextFieldArray[5] = new BorderedSwingSetText("");
        jTextFieldArray[5].setHorizontalAlignment(2);
        jPanel7.add(jTextFieldArray[5]);
        JPanel jPanel8 = MailShow.createVerticalPanel(true);
        jPanel8.setAlignmentX(0.0f);
        jPanel8.setAlignmentY(0.0f);
        jPanel8.add(jPanel2);
        jPanel8.add(jPanel3);
        jPanel8.add(jPanel4);
        jPanel8.add(jPanel5);
        jPanel8.add(jPanel6);
        jPanel8.add(jPanel7);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(this.mf.data);
        jTextArea.setEditable(false);
        jPanel8.add(jTextArea);
        return jPanel8;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("\u8fd4\u4fe1")) {
            ReplyMail replyMail = new ReplyMail(this.mf.from, this.mf.to, "Re:" + this.mf.subject, "", "", this.mf.data);
            Desktop desktop = Desktop.getInstance();
            desktop.add(replyMail);
            replyMail.setVisible(true);
        } else if (string.equals("\u5168\u54e1\u306b\u8fd4\u4fe1")) {
            ReplyMail replyMail = new ReplyMail(this.mf.from, this.mf.to, "Re:" + this.mf.subject, this.mf.cc, "", this.mf.data);
            Desktop desktop = Desktop.getInstance();
            desktop.add(replyMail);
            replyMail.setVisible(true);
        }
    }

    public static JPanel createHorizontalPanel(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        if (bl) {
            jPanel.setBorder(loweredBorder);
        }
        return jPanel;
    }

    public static JPanel createVerticalPanel(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (bl) {
            jPanel.setBorder(loweredBorder);
        }
        return jPanel;
    }

    class BorderedSwingSetText
    extends JTextField {
        BorderedSwingSetText(String string) {
            super(string);
            Font font = new Font("MS Gothic", 1, 14);
        }

        public Dimension getPreferredSize() {
            return new Dimension(400, 20);
        }

        public Dimension getMaximumSize() {
            return new Dimension(1000, 20);
        }

        public boolean isEditable() {
            return false;
        }

        public Border getBorder() {
            return null;
        }
    }

    class BorderedSetLabel
    extends JLabel {
        BorderedSetLabel(String string) {
            super(string);
            this.setHorizontalAlignment(4);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(4);
            Font font = new Font("MS Gothic", 1, 14);
        }

        public float getAlignX() {
            return 0.0f;
        }

        public Dimension getPreferredSize() {
            return new Dimension(80, 20);
        }

        public Dimension getMaximumSize() {
            return new Dimension(80, 20);
        }
    }
}

