/*
 * Decompiled with CFR 0.152.
 */
package net.twoch.GikoMail;

import java.util.Enumeration;
import java.util.Vector;
import net.twoch.GikoMail.CSVTokenizer;

public class CSVLine {
    public static final String copyright = "Copyright 1997 TAMURA Kent\nCopyright 1999 ANDOH Tomoharu";
    private Vector items = new Vector();

    public void addItem(String string) {
        this.addItem(string, false);
    }

    public void addItem(String string, boolean bl) {
        this.items.addElement(new Element(string, bl));
    }

    public void addItem(CSVTokenizer cSVTokenizer) {
        while (cSVTokenizer.hasMoreTokens()) {
            String string = cSVTokenizer.nextToken();
            this.items.addElement(new Element(string));
        }
    }

    public String getLine() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.items.size()) {
            Element element = (Element)this.items.elementAt(n);
            String string = element.getItem();
            stringBuffer.append(string);
            if (this.items.size() - 1 != n) {
                stringBuffer.append(',');
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    public int size() {
        return this.items.size();
    }

    public String getItem(int n) {
        Element element = (Element)this.items.elementAt(n);
        return element.getRawItem();
    }

    public void removeItem(int n) {
        this.items.removeElementAt(n);
    }

    public Enumeration elements() {
        return new CSVLineEnumerator(this.items);
    }

    public static String enquote(String string) {
        return CSVLine.enquote(string, false);
    }

    public static String enquote(String string, boolean bl) {
        if (string.length() == 0) {
            return string;
        }
        if (string.indexOf(34) < 0 && string.indexOf(44) < 0 && !bl) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2 + 2);
        stringBuffer.append('\"');
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if ('\"' == c) {
                stringBuffer.append("\"\"");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        stringBuffer.append('\"');
        return new String(stringBuffer);
    }

    class CSVLineEnumerator
    implements Enumeration {
        private Vector items;
        private int n;

        CSVLineEnumerator(Vector vector) {
            this.items = vector;
            this.n = 0;
        }

        public Object nextElement() {
            ++this.n;
            Element element = (Element)this.items.elementAt(this.n - 1);
            return element.getRawItem();
        }

        public boolean hasMoreElements() {
            return this.n < this.items.size();
        }
    }

    class Element {
        private String item;
        private boolean enquote;

        Element(String string) {
            this(string, false);
        }

        Element(String string, boolean bl) {
            this.item = string;
            this.enquote = bl;
        }

        public String getItem() {
            return CSVLine.enquote(this.item, this.enquote);
        }

        public String getRawItem() {
            return this.item;
        }
    }
}

