<?xml version="1.0" encoding="UTF-8"?>
<!--
 Copyright (C) MX4J.
 All rights reserved.

 This software is distributed under the terms of the MX4J License version 1.0.
 See the terms of the MX4J License in the documentation provided with this software.

 Author: Carlos Quiroz (tibu@users.sourceforge.net)
 Revision: $Revision: 1.2 $
																																					-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output encoding="ISO-8859-1" indent="yes" method="html"/>
  <xsl:include href="common.xsl"/>
  <xsl:include href="xalan-ext.xsl"/>
  <xsl:param name="head.title">about.title</xsl:param>
  <!-- Main template -->
  <xsl:template match="/MBean">
    <html>
      <xsl:call-template name="head"/>
      <body bgcolor="#FFFFFF" leftmargin="0"
        onLoad="MM_preloadImages('images/bkgd_onglet_contact_on.gif','images/btn_top_on.gif')" text="#000000" topmargin="0">
        <xsl:call-template name="toprow">
          <xsl:with-param name="selection">about</xsl:with-param>
        </xsl:call-template>
        <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
          <tr bgcolor="#660066">
            <td class="titre1" height="17"/>
            <td align="right" height="17" valign="middle">
              <img src="images/titres/tit_a_propos_{$request.locale}.gif"/>
            </td>
          </tr>
        </table>
        <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
          <tr>
            <td align="center">
              <h3>
                <!--xsl:variable name="str.url">
                  <xsl:call-template name="str">
                    <xsl:with-param name="id">about.main.url</xsl:with-param>
                  </xsl:call-template>
                </xsl:variable>
                <a href="{$str.url}"-->
                  <xsl:call-template name="str">
                    <xsl:with-param name="id">about.main.title</xsl:with-param>
                  </xsl:call-template>
                <!--/a-->
              </h3>
            </td>
          </tr>
          <tr>
            <td align="center">
              <h3>
                <xsl:call-template name="str">
                  <xsl:with-param name="id">about.main.implementation</xsl:with-param>
                </xsl:call-template>&#160;
                <xsl:value-of select="./Attribute[@name='ImplementationName']/@value"/>
              </h3>
            </td>
          </tr>
          <tr>
            <td align="center">
              <h3>
                <xsl:call-template name="str">
                  <xsl:with-param name="id">about.main.implementationversion</xsl:with-param>
                </xsl:call-template>&#160;
                <xsl:value-of select="./Attribute[@name='ImplementationVersion']/@value"/>
              </h3>
            </td>
          </tr>
          <tr>
            <td>
              <h3 align="center">
                <xsl:call-template name="str">
                  <xsl:with-param name="id">about.main.serverid</xsl:with-param>
                </xsl:call-template>&#160;
                <xsl:value-of select="./Attribute[@name='MBeanServerId']/@value"/>
              </h3>
            </td>
          </tr>
        </table>
        <xsl:call-template name="bottom"/>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
