/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathContextFactoryConfigurationError;

public abstract class JXPathContextFactory {
    public static final String FACTORY_NAME_PROPERTY = "org.apache.commons.jxpath.JXPathContextFactory";
    private static final String DEFAULT_FACTORY_CLASS = "org.apache.commons.jxpath.ri.JXPathContextFactoryReferenceImpl";
    private static String foundFactory = null;
    private static boolean debug = false;
    static /* synthetic */ Class class$org$apache$commons$jxpath$JXPathContextFactory;

    protected JXPathContextFactory() {
    }

    public static JXPathContextFactory newInstance() {
        JXPathContextFactory factoryImpl;
        String factoryImplName = JXPathContextFactory.findFactory(FACTORY_NAME_PROPERTY, DEFAULT_FACTORY_CLASS);
        if (factoryImplName == null) {
            throw new JXPathContextFactoryConfigurationError("No default implementation found");
        }
        try {
            Class<?> clazz = Class.forName(factoryImplName);
            factoryImpl = (JXPathContextFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new JXPathContextFactoryConfigurationError(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new JXPathContextFactoryConfigurationError(iae);
        }
        catch (InstantiationException ie) {
            throw new JXPathContextFactoryConfigurationError(ie);
        }
        return factoryImpl;
    }

    public abstract JXPathContext newContext(JXPathContext var1, Object var2) throws JXPathContextFactoryConfigurationError;

    private static String findFactory(String property, String defaultFactory) {
        block21: {
            block20: {
                String systemProp;
                try {
                    systemProp = System.getProperty(property);
                    if (systemProp != null) {
                        if (debug) {
                            System.err.println("JXPath: found system property" + systemProp);
                        }
                        return systemProp;
                    }
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                if (foundFactory != null) {
                    return foundFactory;
                }
                try {
                    systemProp = System.getProperty(property);
                    if (systemProp != null) {
                        if (debug) {
                            System.err.println("JXPath: found system property" + systemProp);
                        }
                        return systemProp;
                    }
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                try {
                    String javah = System.getProperty("java.home");
                    String configFile = javah + File.separator + "lib" + File.separator + "jxpath.properties";
                    File f = new File(configFile);
                    if (f.exists()) {
                        Properties props = new Properties();
                        props.load(new FileInputStream(f));
                        foundFactory = props.getProperty(property);
                        if (debug) {
                            System.err.println("JXPath: found java.home property " + foundFactory);
                        }
                        if (foundFactory != null) {
                            return foundFactory;
                        }
                    }
                }
                catch (Exception ex) {
                    if (!debug) break block20;
                    ex.printStackTrace();
                }
            }
            String serviceId = "META-INF/services/" + property;
            try {
                ClassLoader cl = (class$org$apache$commons$jxpath$JXPathContextFactory == null ? (class$org$apache$commons$jxpath$JXPathContextFactory = JXPathContextFactory.class$(FACTORY_NAME_PROPERTY)) : class$org$apache$commons$jxpath$JXPathContextFactory).getClassLoader();
                InputStream is = null;
                is = cl == null ? ClassLoader.getSystemResourceAsStream(serviceId) : cl.getResourceAsStream(serviceId);
                if (is != null) {
                    if (debug) {
                        System.err.println("JXPath: found  " + serviceId);
                    }
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                    foundFactory = rd.readLine();
                    rd.close();
                    if (debug) {
                        System.err.println("JXPath: loaded from services: " + foundFactory);
                    }
                    if (foundFactory != null && !"".equals(foundFactory)) {
                        return foundFactory;
                    }
                }
            }
            catch (Exception ex) {
                if (!debug) break block21;
                ex.printStackTrace();
            }
        }
        return defaultFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            debug = System.getProperty("jxpath.debug") != null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

