/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.sbbi.upnp.devices.UPNPDevice;
import net.sbbi.upnp.devices.UPNPRootDevice;
import net.sbbi.upnp.messages.ActionMessage;
import net.sbbi.upnp.messages.ActionResponse;
import net.sbbi.upnp.messages.StateVariableMessage;
import net.sbbi.upnp.messages.StateVariableResponse;
import net.sbbi.upnp.messages.UPNPMessageFactory;
import net.sbbi.upnp.messages.UPNPResponseException;
import net.sbbi.upnp.services.ServiceAction;
import net.sbbi.upnp.services.ServiceActionArgument;
import net.sbbi.upnp.services.ServiceStateVariable;
import net.sbbi.upnp.services.UPNPService;

public class UPNPServiceMBean
implements DynamicMBean {
    private UPNPService service;
    private UPNPDevice device;
    private UPNPMessageFactory fact;
    private ResourceBundle bundle;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Map;

    public UPNPServiceMBean(UPNPDevice device, UPNPService service) {
        this(device, service, null, null);
    }

    public UPNPServiceMBean(UPNPDevice device, UPNPService service, Locale locale, String bundlePackage) {
        this.service = service;
        this.device = device;
        if (locale != null) {
            if (bundlePackage != null && bundlePackage.length() == 0) {
                bundlePackage = null;
            }
            String bundlename = service.getServiceId().replace(':', '_');
            if (bundlePackage != null) {
                if (!bundlePackage.endsWith("/")) {
                    bundlePackage = bundlePackage + "/";
                }
                bundlename = bundlePackage + bundlename;
            }
            try {
                this.bundle = ResourceBundle.getBundle(bundlename, locale);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.fact = UPNPMessageFactory.getNewInstance(service);
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        StateVariableMessage msg = this.fact.getStateVariableMessage(attributeName);
        if (msg != null) {
            try {
                StateVariableResponse resp = msg.service();
                return resp.getStateVariableValue();
            }
            catch (Exception ex) {
                if (ex instanceof UPNPResponseException) {
                    UPNPResponseException respEx = (UPNPResponseException)ex;
                    if (respEx.getDetailErrorCode() == 404) {
                        throw new AttributeNotFoundException(respEx.getDetailErrorCode() + ":" + respEx.getDetailErrorDescription());
                    }
                    throw new MBeanException(ex, respEx.getDetailErrorCode() + ":" + respEx.getDetailErrorDescription());
                }
                throw new MBeanException(ex);
            }
        }
        throw new AttributeNotFoundException("Unable to find attribute " + attributeName);
    }

    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Attribute attr = new Attribute(attributeNames[i], this.getAttribute(attributeNames[i]));
                list.add(attr);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return list;
    }

    public MBeanInfo getMBeanInfo() {
        Iterator itr = this.service.getAvailableStateVariableName();
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[this.service.getAvailableStateVariableSize()];
        int i = 0;
        while (itr.hasNext()) {
            String stateVariable = (String)itr.next();
            ServiceStateVariable var = this.service.getUPNPServiceStateVariable(stateVariable);
            Class type = var.getDataTypeAsClass();
            String variableName = null;
            if (this.bundle != null) {
                try {
                    variableName = this.bundle.getString("attribute." + stateVariable);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (variableName == null) {
                variableName = stateVariable + " description";
            }
            MBeanAttributeInfo info = new MBeanAttributeInfo(stateVariable, type != null ? type.getName() : (class$java$lang$String == null ? UPNPServiceMBean.class$("java.lang.String") : class$java$lang$String).getName(), variableName, true, false, false);
            attrs[i++] = info;
        }
        itr = this.service.getAvailableActionsName();
        MBeanOperationInfo[] operations = new MBeanOperationInfo[this.service.getAvailableActionsSize()];
        i = 0;
        while (itr.hasNext()) {
            String serviceAction = (String)itr.next();
            ServiceAction action = this.service.getUPNPServiceAction(serviceAction);
            List args = action.getInputActionArguments();
            MBeanParameterInfo[] params = null;
            if (args != null) {
                ArrayList<MBeanParameterInfo> tmp = new ArrayList<MBeanParameterInfo>();
                params = new MBeanParameterInfo[args.size()];
                int z = 0;
                Iterator itr2 = args.iterator();
                while (itr2.hasNext()) {
                    ServiceActionArgument actArg = (ServiceActionArgument)itr2.next();
                    Class type = actArg.getRelatedStateVariable().getDataTypeAsClass();
                    String className = type != null ? type.getName() : (class$java$lang$String == null ? UPNPServiceMBean.class$("java.lang.String") : class$java$lang$String).getName();
                    String actionArgName = null;
                    if (this.bundle != null) {
                        try {
                            actionArgName = this.bundle.getString("operation." + action.getName() + "." + actArg.getName());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (actionArgName == null) {
                        actionArgName = actArg.getName() + " description";
                    }
                    MBeanParameterInfo param = new MBeanParameterInfo(actArg.getName(), className, actionArgName);
                    tmp.add(param);
                    params[z++] = param;
                }
                z = 0;
                params = new MBeanParameterInfo[tmp.size()];
                Iterator itr3 = tmp.iterator();
                while (itr3.hasNext()) {
                    params[z++] = (MBeanParameterInfo)itr3.next();
                }
            } else {
                params = new MBeanParameterInfo[]{};
            }
            String returnType = (class$java$util$Map == null ? UPNPServiceMBean.class$("java.util.Map") : class$java$util$Map).getName();
            if (action.getOutputActionArguments() == null) {
                returnType = Void.TYPE.getName();
            }
            String actionName = null;
            if (this.bundle != null) {
                try {
                    actionName = this.bundle.getString("operation." + action.getName());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (actionName == null) {
                actionName = action.getName() + " description";
            }
            MBeanOperationInfo info = new MBeanOperationInfo(action.getName(), actionName, params, returnType, 1);
            operations[i++] = info;
        }
        String serviceDescr = null;
        if (this.bundle != null) {
            try {
                serviceDescr = this.bundle.getString("service.name");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (serviceDescr == null) {
            serviceDescr = "Service Description";
        }
        return new MBeanInfo(this.getClass().getName(), serviceDescr, attrs, null, operations, null);
    }

    public Object invoke(String operationName, Object[] paramsValue, String[] signature) throws MBeanException, ReflectionException {
        ActionMessage msg = this.fact.getMessage(operationName);
        if (msg != null) {
            try {
                List msgParams = msg.getInputParameterNames();
                if (paramsValue != null && msgParams != null) {
                    if (paramsValue.length != msgParams.size()) {
                        return null;
                    }
                    int i = 0;
                    Iterator itr = msgParams.iterator();
                    while (itr.hasNext()) {
                        String argName = (String)itr.next();
                        try {
                            msg.setInputParameter(argName, paramsValue[i]);
                        }
                        catch (IllegalArgumentException ex) {
                            throw new MBeanException(ex);
                        }
                        ++i;
                    }
                }
                ActionResponse resp = msg.service();
                List outParams = msg.getOutputParameterNames();
                if (outParams != null) {
                    HashMap<String, String> rtrVal = new HashMap<String, String>();
                    Iterator i = outParams.iterator();
                    while (i.hasNext()) {
                        String argName = (String)i.next();
                        String val = resp.getOutActionArgumentValue(argName);
                        rtrVal.put(argName, val);
                    }
                    return rtrVal;
                }
                return null;
            }
            catch (Exception ex) {
                if (ex instanceof UPNPResponseException) {
                    UPNPResponseException upnpEx = (UPNPResponseException)ex;
                    throw new MBeanException(upnpEx, upnpEx.getMessage());
                }
                throw new MBeanException(ex);
            }
        }
        return null;
    }

    public void setAttribute(Attribute attributeName) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException("Unable to set attributes on an UPNP device");
    }

    public AttributeList setAttributes(AttributeList attributeNames) {
        return null;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        return new ObjectName(this.getDeviceDomainName(this.device.getDeviceType()) + ":name=" + this.getDeviceServiceName(this.service.getServiceId()) + "_" + this.hashCode());
    }

    private String getDeviceDomainName(String deviceType) {
        String[] tokens = deviceType.split(":");
        return tokens[tokens.length - 2].replace(':', '_');
    }

    private String getDeviceServiceName(String serviceId) {
        String[] tokens = serviceId.split(":");
        return tokens[tokens.length - 1];
    }

    public static UPNPServiceMBean[] getUPNPRootDeviceAsMBeans(UPNPRootDevice device) {
        List services = device.getServices();
        HashSet mBeans = new HashSet();
        if (services != null) {
            UPNPServiceMBean.registerServices(device, services, mBeans);
        }
        UPNPServiceMBean.registerChildDevice(device.getChildDevices(), mBeans);
        UPNPServiceMBean[] rtrVal = new UPNPServiceMBean[mBeans.size()];
        int z = 0;
        Iterator i = mBeans.iterator();
        while (i.hasNext()) {
            rtrVal[z++] = (UPNPServiceMBean)i.next();
        }
        return rtrVal;
    }

    private static void registerServices(UPNPDevice device, List services, Set container) {
        Iterator i = services.iterator();
        while (i.hasNext()) {
            UPNPService srv = (UPNPService)i.next();
            UPNPServiceMBean mBean = new UPNPServiceMBean(device, srv, null, null);
            container.add(mBean);
        }
    }

    private static void registerChildDevice(List childDevices, Set container) {
        if (childDevices != null) {
            Iterator itr = childDevices.iterator();
            while (itr.hasNext()) {
                UPNPDevice device = (UPNPDevice)itr.next();
                List services = device.getServices();
                if (services == null) continue;
                UPNPServiceMBean.registerServices(device, services, container);
            }
        }
    }
}

