/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class HttpResponse {
    private String header;
    private Map fields;
    private String body;

    protected HttpResponse(String rawHttpResponse) throws IllegalArgumentException {
        if (rawHttpResponse == null || rawHttpResponse.trim().length() == 0) {
            throw new IllegalArgumentException("Empty HTTP response message");
        }
        boolean bodyParsing = false;
        StringBuffer bodyParsed = new StringBuffer();
        this.fields = new HashMap();
        String[] lines = rawHttpResponse.split("\\r\\n");
        this.header = lines[0].trim();
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            if (line.length() == 0) {
                bodyParsing = true;
                continue;
            }
            if (bodyParsing) {
                bodyParsed.append(line).append("\r\n");
                continue;
            }
            if (line.length() <= 0) continue;
            int delim = line.indexOf(58);
            if (delim != -1) {
                String key = line.substring(0, delim).toUpperCase();
                String value = line.substring(delim + 1).trim();
                this.fields.put(key, value);
                continue;
            }
            throw new IllegalArgumentException("Invalid HTTP message header :" + line);
        }
        if (bodyParsing) {
            this.body = bodyParsed.toString();
        }
    }

    public String getHeader() {
        return this.header;
    }

    public String getBody() {
        return this.body;
    }

    public String getHTTPFieldElement(String fieldName, String elementName) throws IllegalArgumentException {
        String fieldNameValue = this.getHTTPHeaderField(fieldName);
        if (fieldName != null) {
            StringTokenizer tokenizer = new StringTokenizer(fieldNameValue.trim(), ",");
            while (tokenizer.countTokens() > 0) {
                int index;
                String nextToken = tokenizer.nextToken().trim();
                if (!nextToken.startsWith(elementName) || (index = nextToken.indexOf("=")) == -1) continue;
                return nextToken.substring(index + 1).trim();
            }
        }
        throw new IllegalArgumentException("HTTP element field " + elementName + " is not present");
    }

    public String getHTTPHeaderField(String fieldName) throws IllegalArgumentException {
        String field = (String)this.fields.get(fieldName.toUpperCase());
        if (field == null) {
            throw new IllegalArgumentException("HTTP field " + fieldName + " is not present");
        }
        return field;
    }
}

