/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sbbi.upnp.DiscoveryResultsHandler;
import net.sbbi.upnp.HttpResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiscoveryListener
implements Runnable {
    private static final Log log = LogFactory.getLog(DiscoveryListener.class);
    private static boolean MATCH_IP = true;
    private static final int DEFAULT_TIMEOUT = 250;
    private Map registeredHandlers = new HashMap();
    private final Object REGISTRATION_PROCESS = new Object();
    private static final DiscoveryListener singleton;
    private boolean inService = false;
    private boolean daemon = true;
    private MulticastSocket skt;
    private DatagramPacket input;

    private DiscoveryListener() {
    }

    public static final DiscoveryListener getInstance() {
        return singleton;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResultsHandler(DiscoveryResultsHandler resultsHandler, String searchTarget) throws IOException {
        Object object = this.REGISTRATION_PROCESS;
        synchronized (object) {
            HashSet<DiscoveryResultsHandler> handlers;
            if (!this.inService) {
                this.startDevicesListenerThread();
            }
            if ((handlers = (HashSet<DiscoveryResultsHandler>)this.registeredHandlers.get(searchTarget)) == null) {
                handlers = new HashSet<DiscoveryResultsHandler>();
                this.registeredHandlers.put(searchTarget, handlers);
            }
            handlers.add(resultsHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterResultsHandler(DiscoveryResultsHandler resultsHandler, String searchTarget) {
        Object object = this.REGISTRATION_PROCESS;
        synchronized (object) {
            Set handlers = (Set)this.registeredHandlers.get(searchTarget);
            if (handlers != null) {
                handlers.remove(resultsHandler);
                if (handlers.size() == 0) {
                    this.registeredHandlers.remove(searchTarget);
                }
            }
            if (this.registeredHandlers.size() == 0) {
                this.stopDevicesListenerThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDevicesListenerThread() throws IOException {
        DiscoveryListener discoveryListener = singleton;
        synchronized (discoveryListener) {
            if (!this.inService) {
                this.startMultiCastSocket();
                Thread deamon = new Thread((Runnable)this, "DiscoveryListener daemon");
                deamon.setDaemon(this.daemon);
                deamon.start();
                while (!this.inService) {
                    try {
                        Thread.sleep(2L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDevicesListenerThread() {
        DiscoveryListener discoveryListener = singleton;
        synchronized (discoveryListener) {
            this.inService = false;
        }
    }

    private void startMultiCastSocket() throws IOException {
        int bindPort = 1901;
        String port = System.getProperty("net.sbbi.upnp.Discovery.bindPort");
        if (port != null) {
            bindPort = Integer.parseInt(port);
        }
        this.skt = new MulticastSocket(null);
        this.skt.bind(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), bindPort));
        this.skt.setTimeToLive(4);
        this.skt.setSoTimeout(250);
        this.skt.joinGroup(InetAddress.getByName("239.255.255.250"));
        byte[] buf = new byte[2048];
        this.input = new DatagramPacket(buf, buf.length);
    }

    public void run() {
        if (!Thread.currentThread().getName().equals("DiscoveryListener daemon")) {
            throw new RuntimeException("No right to call this method");
        }
        this.inService = true;
        while (this.inService) {
            try {
                this.listenBroadCast();
            }
            catch (SocketTimeoutException ex) {
            }
            catch (IOException ioEx) {
                log.error("IO Exception during UPNP DiscoveryListener messages listening thread", ioEx);
            }
            catch (Exception ex) {
                log.error("Fatal Error during UPNP DiscoveryListener messages listening thread, thread will exit", ex);
                this.inService = false;
            }
        }
        try {
            this.skt.leaveGroup(InetAddress.getByName("239.255.255.250"));
            this.skt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenBroadCast() throws IOException {
        this.skt.receive(this.input);
        InetAddress from = this.input.getAddress();
        String received = new String(this.input.getData(), this.input.getOffset(), this.input.getLength());
        HttpResponse msg = null;
        try {
            msg = new HttpResponse(received);
        }
        catch (IllegalArgumentException ex) {
            if (log.isDebugEnabled()) {
                log.debug("Skipping uncompliant HTTP message " + received);
            }
            return;
        }
        String header = msg.getHeader();
        if (header != null && header.startsWith("HTTP/1.1 200 OK") && msg.getHTTPHeaderField("st") != null) {
            String st;
            InetAddress locHost;
            String deviceDescrLoc = msg.getHTTPHeaderField("location");
            if (deviceDescrLoc == null || deviceDescrLoc.trim().length() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipping SSDP message, missing HTTP header 'location' field");
                }
                return;
            }
            URL loc = new URL(deviceDescrLoc);
            if (MATCH_IP && !from.equals(locHost = InetAddress.getByName(loc.getHost()))) {
                log.warn("Discovery message sender IP " + from + " does not match device description IP " + locHost + " skipping device, set the net.sbbi.upnp.ddos.matchip system property" + " to false to avoid this check");
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Processing " + deviceDescrLoc + " device description location");
            }
            if ((st = msg.getHTTPHeaderField("st")) == null || st.trim().length() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipping SSDP message, missing HTTP header 'st' field");
                }
                return;
            }
            String usn = msg.getHTTPHeaderField("usn");
            if (usn == null || usn.trim().length() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipping SSDP message, missing HTTP header 'usn' field");
                }
                return;
            }
            String maxAge = msg.getHTTPFieldElement("Cache-Control", "max-age");
            if (maxAge == null || maxAge.trim().length() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipping SSDP message, missing HTTP header 'max-age' field");
                }
                return;
            }
            String server = msg.getHTTPHeaderField("server");
            if (server == null || server.trim().length() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipping SSDP message, missing HTTP header 'server' field");
                }
                return;
            }
            String udn = usn;
            int index = udn.indexOf("::");
            if (index != -1) {
                udn = udn.substring(0, index);
            }
            Object object = this.REGISTRATION_PROCESS;
            synchronized (object) {
                Set handlers = (Set)this.registeredHandlers.get(st);
                if (handlers != null) {
                    Iterator i = handlers.iterator();
                    while (i.hasNext()) {
                        DiscoveryResultsHandler handler = (DiscoveryResultsHandler)i.next();
                        handler.discoveredDevice(usn, udn, st, maxAge, loc, server);
                    }
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Skipping uncompliant HTTP message " + received);
        }
    }

    static {
        String prop = System.getProperty("net.sbbi.upnp.ddos.matchip");
        if (prop != null && prop.equals("false")) {
            MATCH_IP = false;
        }
        singleton = new DiscoveryListener();
    }
}

