/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sbbi.upnp.DiscoveryEventHandler;
import net.sbbi.upnp.HttpResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiscoveryAdvertisement
implements Runnable {
    private static final Log log = LogFactory.getLog(DiscoveryAdvertisement.class);
    private static boolean MATCH_IP = true;
    private static final int DEFAULT_TIMEOUT = 250;
    public static final int EVENT_SSDP_ALIVE = 0;
    public static final int EVENT_SSDP_BYE_BYE = 1;
    private static final String NTS_SSDP_ALIVE = "ssdp:alive";
    private static final String NTS_SSDP_BYE_BYE = "ssdp:byebye";
    private static final String NT_ALL_EVENTS = "DiscoveryAdvertisement:nt:allevents";
    private Map byeByeRegistered = new HashMap();
    private Map aliveRegistered = new HashMap();
    private Map USNPerIP = new HashMap();
    private final Object REGISTRATION_PROCESS = new Object();
    private static final DiscoveryAdvertisement singleton;
    private boolean inService = false;
    private boolean daemon = true;
    private MulticastSocket skt;
    private DatagramPacket input;

    private DiscoveryAdvertisement() {
    }

    public static final DiscoveryAdvertisement getInstance() {
        return singleton;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEvent(int notificationEvent, String nt, DiscoveryEventHandler eventHandler) throws IOException {
        Object object = this.REGISTRATION_PROCESS;
        synchronized (object) {
            if (!this.inService) {
                this.startDevicesListenerThread();
            }
            if (nt == null) {
                nt = NT_ALL_EVENTS;
            }
            if (notificationEvent == 0) {
                HashSet<DiscoveryEventHandler> handlers = (HashSet<DiscoveryEventHandler>)this.aliveRegistered.get(nt);
                if (handlers == null) {
                    handlers = new HashSet<DiscoveryEventHandler>();
                    this.aliveRegistered.put(nt, handlers);
                }
                handlers.add(eventHandler);
            } else if (notificationEvent == 1) {
                HashSet<DiscoveryEventHandler> handlers = (HashSet<DiscoveryEventHandler>)this.byeByeRegistered.get(nt);
                if (handlers == null) {
                    handlers = new HashSet<DiscoveryEventHandler>();
                    this.byeByeRegistered.put(nt, handlers);
                }
                handlers.add(eventHandler);
            } else {
                throw new IllegalArgumentException("Unknown notificationEvent type");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterEvent(int notificationEvent, String nt, DiscoveryEventHandler eventHandler) {
        Object object = this.REGISTRATION_PROCESS;
        synchronized (object) {
            if (nt == null) {
                nt = NT_ALL_EVENTS;
            }
            if (notificationEvent == 0) {
                Set handlers = (Set)this.aliveRegistered.get(nt);
                if (handlers != null) {
                    handlers.remove(eventHandler);
                    if (handlers.size() == 0) {
                        this.aliveRegistered.remove(nt);
                    }
                }
            } else if (notificationEvent == 1) {
                Set handlers = (Set)this.byeByeRegistered.get(nt);
                if (handlers != null) {
                    handlers.remove(eventHandler);
                    if (handlers.size() == 0) {
                        this.byeByeRegistered.remove(nt);
                    }
                }
            } else {
                throw new IllegalArgumentException("Unknown notificationEvent type");
            }
            if (this.aliveRegistered.size() == 0 && this.byeByeRegistered.size() == 0) {
                this.stopDevicesListenerThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDevicesListenerThread() throws IOException {
        DiscoveryAdvertisement discoveryAdvertisement = singleton;
        synchronized (discoveryAdvertisement) {
            if (!this.inService) {
                this.startMultiCastSocket();
                Thread deamon = new Thread((Runnable)this, "DiscoveryAdvertisement daemon");
                deamon.setDaemon(this.daemon);
                deamon.start();
                while (!this.inService) {
                    try {
                        Thread.sleep(2L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDevicesListenerThread() {
        DiscoveryAdvertisement discoveryAdvertisement = singleton;
        synchronized (discoveryAdvertisement) {
            this.inService = false;
        }
    }

    private void startMultiCastSocket() throws IOException {
        this.skt = new MulticastSocket(null);
        this.skt.bind(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 1900));
        this.skt.setTimeToLive(4);
        this.skt.setSoTimeout(250);
        this.skt.joinGroup(InetAddress.getByName("239.255.255.250"));
        byte[] buf = new byte[2048];
        this.input = new DatagramPacket(buf, buf.length);
    }

    public void run() {
        if (!Thread.currentThread().getName().equals("DiscoveryAdvertisement daemon")) {
            throw new RuntimeException("No right to call this method");
        }
        this.inService = true;
        while (this.inService) {
            try {
                this.listenBroadCast();
            }
            catch (SocketTimeoutException ex) {
            }
            catch (IOException ioEx) {
                log.error("IO Exception during UPNP DiscoveryAdvertisement messages listening thread", ioEx);
            }
            catch (Exception ex) {
                log.error("Fatal Error during UPNP DiscoveryAdvertisement messages listening thread, thread will exit", ex);
                this.inService = false;
                this.aliveRegistered.clear();
                this.byeByeRegistered.clear();
                this.USNPerIP.clear();
            }
        }
        try {
            this.skt.leaveGroup(InetAddress.getByName("239.255.255.250"));
            this.skt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenBroadCast() throws IOException {
        this.skt.receive(this.input);
        InetAddress from = this.input.getAddress();
        String received = new String(this.input.getData(), this.input.getOffset(), this.input.getLength());
        HttpResponse msg = null;
        try {
            msg = new HttpResponse(received);
        }
        catch (IllegalArgumentException ex) {
            if (log.isDebugEnabled()) {
                log.debug("Skipping uncompliant HTTP message " + received);
            }
            return;
        }
        String header = msg.getHeader();
        if (header != null && header.startsWith("NOTIFY")) {
            String ntsField;
            if (log.isDebugEnabled()) {
                log.debug(received);
            }
            if ((ntsField = msg.getHTTPHeaderField("nts")) == null || ntsField.trim().length() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipping SSDP message, missing HTTP header 'ntsField' field");
                }
                return;
            }
            if (ntsField.equals(NTS_SSDP_ALIVE)) {
                InetAddress locHost;
                String deviceDescrLoc = msg.getHTTPHeaderField("location");
                if (deviceDescrLoc == null || deviceDescrLoc.trim().length() == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Skipping SSDP message, missing HTTP header 'location' field");
                    }
                    return;
                }
                URL loc = new URL(deviceDescrLoc);
                if (MATCH_IP && !from.equals(locHost = InetAddress.getByName(loc.getHost()))) {
                    log.warn("Discovery message sender IP " + from + " does not match device description IP " + locHost + " skipping message, set the net.sbbi.upnp.ddos.matchip system property" + " to false to avoid this check");
                    return;
                }
                String nt = msg.getHTTPHeaderField("nt");
                if (nt == null || nt.trim().length() == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Skipping SSDP message, missing HTTP header 'nt' field");
                    }
                    return;
                }
                String maxAge = msg.getHTTPFieldElement("Cache-Control", "max-age");
                if (maxAge == null || maxAge.trim().length() == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Skipping SSDP message, missing HTTP header 'max-age' field");
                    }
                    return;
                }
                String usn = msg.getHTTPHeaderField("usn");
                if (usn == null || usn.trim().length() == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Skipping SSDP message, missing HTTP header 'usn' field");
                    }
                    return;
                }
                this.USNPerIP.put(usn, from);
                String udn = usn;
                int index = udn.indexOf("::");
                if (index != -1) {
                    udn = udn.substring(0, index);
                }
                Object object = this.REGISTRATION_PROCESS;
                synchronized (object) {
                    DiscoveryEventHandler eventHandler;
                    Iterator i;
                    Set handlers = (Set)this.aliveRegistered.get(NT_ALL_EVENTS);
                    if (handlers != null) {
                        i = handlers.iterator();
                        while (i.hasNext()) {
                            eventHandler = (DiscoveryEventHandler)i.next();
                            eventHandler.eventSSDPAlive(usn, udn, nt, maxAge, loc);
                        }
                    }
                    if ((handlers = (Set)this.aliveRegistered.get(nt)) != null) {
                        i = handlers.iterator();
                        while (i.hasNext()) {
                            eventHandler = (DiscoveryEventHandler)i.next();
                            eventHandler.eventSSDPAlive(usn, udn, nt, maxAge, loc);
                        }
                    }
                }
            } else if (ntsField.equals(NTS_SSDP_BYE_BYE)) {
                String usn = msg.getHTTPHeaderField("usn");
                if (usn == null || usn.trim().length() == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Skipping SSDP message, missing HTTP header 'usn' field");
                    }
                    return;
                }
                String nt = msg.getHTTPHeaderField("nt");
                if (nt == null || nt.trim().length() == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Skipping SSDP message, missing HTTP header 'nt' field");
                    }
                    return;
                }
                InetAddress originalAliveSenderIp = (InetAddress)this.USNPerIP.get(usn);
                if (originalAliveSenderIp != null && !originalAliveSenderIp.equals(from)) {
                    return;
                }
                String udn = usn;
                int index = udn.indexOf("::");
                if (index != -1) {
                    udn = udn.substring(0, index);
                }
                Object object = this.REGISTRATION_PROCESS;
                synchronized (object) {
                    DiscoveryEventHandler eventHandler;
                    Iterator i;
                    Set handlers = (Set)this.byeByeRegistered.get(NT_ALL_EVENTS);
                    if (handlers != null) {
                        i = handlers.iterator();
                        while (i.hasNext()) {
                            eventHandler = (DiscoveryEventHandler)i.next();
                            eventHandler.eventSSDPByeBye(usn, udn, nt);
                        }
                    }
                    if ((handlers = (Set)this.byeByeRegistered.get(nt)) != null) {
                        i = handlers.iterator();
                        while (i.hasNext()) {
                            eventHandler = (DiscoveryEventHandler)i.next();
                            eventHandler.eventSSDPByeBye(usn, udn, nt);
                        }
                    }
                }
            } else {
                log.warn("Unvalid NTS field value (" + ntsField + ") received in NOTIFY message :" + received);
            }
        }
    }

    static {
        String prop = System.getProperty("net.sbbi.upnp.ddos.matchip");
        if (prop != null && prop.equals("false")) {
            MATCH_IP = false;
        }
        singleton = new DiscoveryAdvertisement();
    }
}

