/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.resolver.local;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import mx4j.remote.ConnectionResolver;
import mx4j.tools.remote.local.LocalConnectorServer;

public class LOCALResolver
extends ConnectionResolver {
    private static final String ID_CONTEXT = "/id/";
    private static int connectorID;
    private final Map mbeanServerIds = new HashMap();
    static /* synthetic */ Class class$mx4j$tools$remote$resolver$local$LOCALResolver;

    public Object createServer(JMXServiceURL url, Map environment) throws IOException {
        String connectorID = this.findConnectorID(url);
        if (connectorID == null) {
            return null;
        }
        String mbeanServerId = this.findMBeanServerId(connectorID);
        if (mbeanServerId == null) {
            return null;
        }
        ArrayList servers = MBeanServerFactory.findMBeanServer(mbeanServerId);
        if (servers.size() == 1) {
            return servers.get(0);
        }
        return null;
    }

    private String findConnectorID(JMXServiceURL url) {
        String path = url.getURLPath();
        if (path == null || !path.startsWith(ID_CONTEXT)) {
            return null;
        }
        return path.substring(ID_CONTEXT.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findMBeanServerId(String connectorID) {
        Map map = this.mbeanServerIds;
        synchronized (map) {
            return (String)this.mbeanServerIds.get(connectorID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMXServiceURL bindServer(Object server, JMXServiceURL url, Map environment) throws IOException {
        String connectorID = this.findConnectorID(url);
        if (connectorID == null) {
            connectorID = this.generateConnectorID();
        }
        MBeanServer mbeanServer = (MBeanServer)server;
        try {
            String mbeanServerId = (String)mbeanServer.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
            Map map = this.mbeanServerIds;
            synchronized (map) {
                String existing = this.findMBeanServerId(connectorID);
                if (existing != null && !existing.equals(mbeanServerId)) {
                    throw new IOException("LocalConnectorServer with ID " + connectorID + " is already attached to MBeanServer with ID " + existing);
                }
                this.mbeanServerIds.put(connectorID, mbeanServerId);
            }
        }
        catch (JMException x) {
            throw new IOException("Cannot retrieve MBeanServer ID " + x.toString());
        }
        return new JMXServiceURL(url.getProtocol(), url.getHost(), url.getPort(), ID_CONTEXT + connectorID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateConnectorID() {
        Class clazz = class$mx4j$tools$remote$resolver$local$LOCALResolver == null ? (class$mx4j$tools$remote$resolver$local$LOCALResolver = LOCALResolver.class$("mx4j.tools.remote.resolver.local.LOCALResolver")) : class$mx4j$tools$remote$resolver$local$LOCALResolver;
        synchronized (clazz) {
            return String.valueOf(++connectorID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindServer(Object server, JMXServiceURL address, Map environment) throws IOException {
        String connectorID = this.findConnectorID(address);
        if (connectorID == null) {
            throw new IOException("Unknown LocalConnectorServer ID: " + address);
        }
        Map map = this.mbeanServerIds;
        synchronized (map) {
            this.mbeanServerIds.remove(connectorID);
        }
    }

    public void destroyServer(Object server, JMXServiceURL url, Map environment) throws IOException {
    }

    public Object lookupClient(JMXServiceURL url, Map environment) throws IOException {
        return LocalConnectorServer.find(url);
    }

    public Object bindClient(Object client, Map environment) throws IOException {
        return client;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

