/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.util.console;

import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.CommandFactory;
import de.uniba.wiai.lspi.util.console.ConsoleException;
import de.uniba.wiai.lspi.util.console.ConsoleThread;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;

public class ExecuteMacro
extends Command {
    public static final String COMMAND_NAME = "executeMacro";
    public static final String FILE_PARAM = "file";
    public static final String TIMES_PARAM = "times";

    public ExecuteMacro(Object[] toCommand, PrintStream out) {
        super(toCommand, out);
    }

    public void printOutHelp() {
        this.out.println("This command executes commands saved in a txt file.");
        this.out.println("Each command must be placed in a separate line.");
        this.out.println("There must be no empty line within the file.");
        this.out.println("The file name has to be provided as value of parameter 'file'.");
        this.out.println("The path to the file can be specified relative to the directory from where this console has been started or as an absoulte path. As path separator '/' has to be used.");
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public void exec() throws ConsoleException {
        String filename = (String)this.parameters.get(FILE_PARAM);
        if (filename == null || filename.length() == 0) {
            throw new ConsoleException("file parameter is missing!");
        }
        String timesString = (String)this.parameters.get(TIMES_PARAM);
        int times = 1;
        if (timesString != null && timesString.length() != 0) {
            try {
                times = Integer.parseInt(timesString);
            }
            catch (NumberFormatException e) {
                throw new ConsoleException("times is not a valid number!");
            }
        }
        if (times < 1) {
            times = 1;
        }
        this.out.println("Trying to open macro file '" + filename + "'.");
        int linesRead = 0;
        try {
            this.out.println("Executing macro " + times + " time(s).");
            for (int i = 0; i < times; ++i) {
                this.out.println(i);
                FileReader fileInput = new FileReader(filename);
                BufferedReader reader = new BufferedReader(fileInput);
                String line = reader.readLine();
                ++linesRead;
                while (line != null) {
                    CommandFactory factory = ConsoleThread.getConsole().getCommandFactory();
                    this.out.println("MACRO EXECUTION: Line read from file: '" + line + "'.");
                    Command cmd = factory.createCommand(line);
                    this.out.println("MACRO EXECUTION: Executing command " + cmd.getCommandName());
                    cmd.execute();
                    line = reader.readLine();
                    ++linesRead;
                }
                linesRead = 0;
                reader.close();
                fileInput.close();
            }
        }
        catch (IOException e) {
            throw new ConsoleException("IO error while reading macro file. Lines read successfully: " + linesRead + ". In round " + times + ".Message: " + e.getMessage());
        }
    }
}

