/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.util.console;

import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.ConsoleException;
import de.uniba.wiai.lspi.util.console.parser.CommandParser;
import de.uniba.wiai.lspi.util.console.parser.ParseException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandFactory {
    protected Object[] toCommand;
    protected Map<String, String> commandMapping;
    protected Map<String, Command> instanceMap;
    protected PrintStream out;

    public CommandFactory(Object[] toCommand, PrintStream out, Map<String, String> commandMapping) {
        this.toCommand = new Object[toCommand.length];
        System.arraycopy(toCommand, 0, this.toCommand, 0, this.toCommand.length);
        this.out = out;
        this.commandMapping = commandMapping;
        this.instanceMap = new HashMap<String, Command>();
    }

    public void addCommand(String name, String cmdClass) {
        this.commandMapping.put(name, cmdClass);
    }

    public PrintStream getPrintStream() {
        return this.out;
    }

    public Command createCommand(String commandLine) throws ConsoleException {
        if (commandLine == null) {
            throw new IllegalArgumentException("commandLine must not be null!");
        }
        Command com = null;
        try {
            String command = CommandParser.parse(commandLine);
            Map<String, String> parameters = CommandParser.parseParams(commandLine);
            if (this.instanceMap.containsKey(command)) {
                com = this.instanceMap.get(command);
            } else {
                String commandClass = this.commandMapping.get(command);
                if (commandClass == null || commandClass.length() == 0) {
                    throw new ConsoleException("Unknown command: '" + command + "'");
                }
                Class<?> comClass = null;
                try {
                    comClass = Class.forName(commandClass);
                }
                catch (ClassNotFoundException e) {
                    throw new ConsoleException("Unknown command: " + command);
                }
                Class[] argtypes = new Class[]{Object[].class, PrintStream.class};
                Constructor<?> comClassCons = null;
                try {
                    comClassCons = comClass.getDeclaredConstructor(argtypes);
                }
                catch (SecurityException e) {
                    throw new ConsoleException("Unknown command: " + command);
                }
                catch (NoSuchMethodException e) {
                    throw new ConsoleException("Unknown command: " + command);
                }
                Object[] arg = new Object[]{this.toCommand, this.out};
                try {
                    com = (Command)comClassCons.newInstance(arg);
                }
                catch (IllegalArgumentException e) {
                    throw new ConsoleException("Unknown command: " + command);
                }
                catch (InstantiationException e) {
                    throw new ConsoleException("Unknown command: " + command);
                }
                catch (IllegalAccessException e) {
                    throw new ConsoleException("Unknown command: " + command);
                }
                catch (InvocationTargetException e) {
                    throw new ConsoleException("Unknown command: " + command);
                }
                this.instanceMap.put(command, com);
            }
            com.setParameters(parameters);
            return com;
        }
        catch (ParseException e) {
            throw new ConsoleException("Command misspelled? Could not parse command.");
        }
    }
}

