/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.service.impl;

import de.uniba.wiai.lspi.chord.com.CommunicationException;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.com.RefsAndEntries;
import de.uniba.wiai.lspi.chord.service.impl.Entries;
import de.uniba.wiai.lspi.chord.service.impl.NodeImpl;
import de.uniba.wiai.lspi.chord.service.impl.References;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.util.List;

final class StabilizeTask
implements Runnable {
    private NodeImpl parent;
    private References references;
    private Entries entries;
    protected static final Logger logger = Logger.getLogger(StabilizeTask.class);

    StabilizeTask(NodeImpl parent, References references, Entries entries) {
        if (parent == null || references == null || entries == null) {
            throw new NullPointerException("No argument to constructor may be null!");
        }
        this.parent = parent;
        this.references = references;
        this.entries = entries;
    }

    public void run() {
        block12: {
            try {
                List<Node> mySuccessorsPredecessorAndSuccessorList;
                Node successor;
                boolean debugEnabled = logger.isEnabledFor(Logger.LogLevel.DEBUG);
                boolean infoEnabled = logger.isEnabledFor(Logger.LogLevel.INFO);
                if (debugEnabled) {
                    logger.debug("Stabilize method has been invoked periodically");
                }
                if ((successor = this.references.getSuccessor()) == null) {
                    if (infoEnabled) {
                        logger.info("Nothing to stabilize, as successor is null");
                        return;
                    }
                    break block12;
                }
                try {
                    mySuccessorsPredecessorAndSuccessorList = successor.notify(this.parent);
                    if (infoEnabled) {
                        logger.info("Received response to notify request from successor" + successor.getNodeID());
                    }
                }
                catch (CommunicationException e) {
                    if (debugEnabled) {
                        logger.debug("Invocation of notify on node " + successor.getNodeID() + " was not successful due to a " + "communication failure! Successor has " + "failed during stabilization! " + "Removing successor!", e);
                    }
                    this.references.removeReference(successor);
                    return;
                }
                if (mySuccessorsPredecessorAndSuccessorList.size() > 0 && mySuccessorsPredecessorAndSuccessorList.get(0) != null && !this.parent.getNodeID().equals(mySuccessorsPredecessorAndSuccessorList.get(0).getNodeID())) {
                    RefsAndEntries refsAndEntries = successor.notifyAndCopyEntries(this.parent);
                    mySuccessorsPredecessorAndSuccessorList = refsAndEntries.getRefs();
                    this.entries.addAll(refsAndEntries.getEntries());
                }
                for (Node newReference : mySuccessorsPredecessorAndSuccessorList) {
                    this.references.addReference(newReference);
                    if (!debugEnabled) continue;
                    logger.debug("Added new reference: " + newReference);
                }
                if (infoEnabled) {
                    logger.info("Invocation of notify on node " + successor.getNodeID() + " was successful");
                }
            }
            catch (Exception e) {
                logger.warn("Unexpected Exception caught in StabilizeTask!", e);
                e.printStackTrace();
            }
        }
    }
}

