/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.service.impl;

import de.uniba.wiai.lspi.chord.service.Chord;
import de.uniba.wiai.lspi.chord.service.Key;
import de.uniba.wiai.lspi.chord.service.impl.ChordFutureImpl;
import java.io.Serializable;
import java.util.concurrent.Executor;

class ChordRemoveFuture
extends ChordFutureImpl {
    private Chord chord;
    private Key key;
    private Serializable entry;

    private ChordRemoveFuture(Chord c, Key k, Serializable entry) {
        this.chord = c;
        this.key = k;
        this.entry = entry;
    }

    static final ChordRemoveFuture create(Executor exec, Chord c, Key k, Serializable entry) {
        if (c == null) {
            throw new IllegalArgumentException("ChordRemoveFuture: chord instance must not be null!");
        }
        if (k == null) {
            throw new IllegalArgumentException("ChordRemoveFuture: key must not be null!");
        }
        if (entry == null) {
            throw new IllegalArgumentException("ChordRemoveFuture: entry must not be null!");
        }
        ChordRemoveFuture f = new ChordRemoveFuture(c, k, entry);
        exec.execute(f.getTask());
        return f;
    }

    private final Runnable getTask() {
        return new RemoveTask(this.chord, this.key, this.entry);
    }

    private class RemoveTask
    implements Runnable {
        private Chord chord;
        private Key key;
        private Serializable entry;

        RemoveTask(Chord chord, Key key, Serializable entry) {
            this.chord = chord;
            this.key = key;
            this.entry = entry;
        }

        public void run() {
            try {
                this.chord.remove(this.key, this.entry);
            }
            catch (Throwable t) {
                ChordRemoveFuture.this.setThrowable(t);
            }
            ChordRemoveFuture.this.setIsDone();
        }
    }
}

