/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.service.impl;

import de.uniba.wiai.lspi.chord.service.Chord;
import de.uniba.wiai.lspi.chord.service.Key;
import de.uniba.wiai.lspi.chord.service.impl.ChordFutureImpl;
import java.io.Serializable;
import java.util.concurrent.Executor;

class ChordInsertFuture
extends ChordFutureImpl {
    private Chord chord;
    private Key key;
    private Serializable entry;

    private ChordInsertFuture(Chord c, Key k, Serializable entry) {
        this.chord = c;
        this.key = k;
        this.entry = entry;
    }

    static final ChordInsertFuture create(Executor exec, Chord c, Key k, Serializable entry) {
        if (c == null) {
            throw new IllegalArgumentException("ChordInsertFuture: chord instance must not be null!");
        }
        if (k == null) {
            throw new IllegalArgumentException("ChordInsertFuture: key must not be null!");
        }
        if (entry == null) {
            throw new IllegalArgumentException("ChordInsertFuture: entry must not be null!");
        }
        ChordInsertFuture f = new ChordInsertFuture(c, k, entry);
        exec.execute(f.getTask());
        return f;
    }

    private final Runnable getTask() {
        return new InsertTask(this.chord, this.key, this.entry);
    }

    private class InsertTask
    implements Runnable {
        private Chord chord;
        private Key key;
        private Serializable entry;

        InsertTask(Chord chord, Key key, Serializable entry) {
            this.chord = chord;
            this.key = key;
            this.entry = entry;
        }

        public void run() {
            try {
                this.chord.insert(this.key, this.entry);
            }
            catch (Throwable t) {
                ChordInsertFuture.this.setThrowable(t);
            }
            ChordInsertFuture.this.setIsDone();
        }
    }
}

