/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console.command;

import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.ConsoleException;
import java.io.PrintStream;

public class Wait
extends Command {
    public static final String COMMAND_NAME = "wait";
    public static final String MILLIS_PARAM = "millis";

    public Wait(Object[] toCommand1, PrintStream out1) {
        super(toCommand1, out1);
    }

    public void exec() throws ConsoleException {
        if (!this.parameters.containsKey(MILLIS_PARAM)) {
            throw new ConsoleException("Not enough parameters. Provide the wait time in millis using the parameter 'millis'.");
        }
        String millisString = (String)this.parameters.get(MILLIS_PARAM);
        try {
            long waitTime = Long.parseLong(millisString);
            Thread.sleep(waitTime);
        }
        catch (NumberFormatException e) {
            throw new ConsoleException("Parameter 'millis' has wrong format.");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public void printOutHelp() {
        this.out.println("The wait command makes the console wait a given time until the next step is done. This is meant to be used in macros.");
        this.out.println("Parameters: ");
        this.out.println("millis takes the number of millis to wait for.");
    }
}

