/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console.command;

import de.uniba.wiai.lspi.chord.console.command.RemoteChordNetworkAccess;
import de.uniba.wiai.lspi.chord.console.command.entry.Key;
import de.uniba.wiai.lspi.chord.service.Chord;
import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.ConsoleException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Set;

public class RetrieveNetwork
extends Command {
    public static final String COMMAND_NAME = "retrieveN";
    protected static final String KEY_PARAM = "key";

    public RetrieveNetwork(Object[] toCommand1, PrintStream out1) {
        super(toCommand1, out1);
    }

    public void exec() throws ConsoleException {
        String key = (String)this.parameters.get(KEY_PARAM);
        if (key == null || key.length() == 0) {
            throw new ConsoleException("Not enough parameters! key is missing.");
        }
        Key keyObject = new Key(key);
        Chord chord = ((RemoteChordNetworkAccess)this.toCommand[1]).getChordInstance();
        try {
            Set<Serializable> vs = chord.retrieve(keyObject);
            Object[] values = vs.toArray(new Object[vs.size()]);
            this.out.println("Values associated with key '" + key + "': ");
            for (int i = 0; i < values.length; ++i) {
                this.out.print(values[i]);
                if (i != values.length - 1) {
                    this.out.print(",");
                }
                this.out.print(" ");
            }
            this.out.println();
        }
        catch (Throwable t) {
            ConsoleException e = new ConsoleException("Exception during execution of command. " + t.getMessage());
            e.setStackTrace(t.getStackTrace());
            throw e;
        }
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public void printOutHelp() {
        this.out.println("This command retrieves and displays the values stored for a provided key in the chord network.");
        this.out.println("The search is initiated by the node provided as parameter.");
        this.out.println("Required parameters: ");
        this.out.println("\tkey: The key for the values.");
        this.out.println();
    }
}

