/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console.command;

import de.uniba.wiai.lspi.chord.console.command.RemoteChordNetworkAccess;
import de.uniba.wiai.lspi.chord.console.command.entry.Key;
import de.uniba.wiai.lspi.chord.console.command.entry.Value;
import de.uniba.wiai.lspi.chord.service.Chord;
import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.ConsoleException;
import java.io.PrintStream;

public class RemoveNetwork
extends Command {
    public static final String COMMAND_NAME = "removeN";
    protected static final String KEY_PARAM = "key";
    protected static final String VALUE_PARAM = "value";

    public RemoveNetwork(Object[] toCommand1, PrintStream out1) {
        super(toCommand1, out1);
    }

    public void exec() throws ConsoleException {
        String key = (String)this.parameters.get(KEY_PARAM);
        String value = (String)this.parameters.get(VALUE_PARAM);
        if (key == null || key.length() == 0) {
            throw new ConsoleException("Not enough parameters! key is missing.");
        }
        if (value == null || value.length() == 0) {
            throw new ConsoleException("Not enough parameters! value is missing.");
        }
        Chord chord = ((RemoteChordNetworkAccess)this.toCommand[1]).getChordInstance();
        Key keyObject = new Key(key);
        Value valueObject = new Value(value);
        try {
            chord.remove(keyObject, valueObject);
        }
        catch (Throwable t) {
            ConsoleException e = new ConsoleException("Exception during execution of command. " + t.getMessage(), t);
            throw e;
        }
        this.out.println("Value '" + value + "' with key '" + key + "' removed.");
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public void printOutHelp() {
        this.out.println("This command removes a value with a provided key from the (remote) chord network.");
        this.out.println("The key is removed starting from the node provided as parameter.");
        this.out.println("Required parameters: ");
        this.out.println("\tkey: The key for the value.");
        this.out.println("\tvalue: The value to remove.");
        this.out.println();
    }
}

