/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console.command;

import de.uniba.wiai.lspi.chord.console.command.RemoteChordNetworkAccess;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.ConsoleException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.Iterator;

public class JoinNetwork
extends Command {
    public static final String COMMAND_NAME = "joinN";
    public static final String BOOTSTRAP_PARAM = "bootstrap";
    public static final String PORT_PARAM = "port";

    public JoinNetwork(Object[] toCommand11, PrintStream out1) {
        super(toCommand11, out1);
    }

    public void exec() throws ConsoleException {
        int port = -1;
        if (this.parameters.containsKey(PORT_PARAM)) {
            try {
                port = Integer.parseInt((String)this.parameters.remove(PORT_PARAM));
            }
            catch (NumberFormatException e) {
                throw new ConsoleException("Port is no integer value! " + e.getMessage());
            }
        }
        if (!this.parameters.containsKey(BOOTSTRAP_PARAM)) {
            this.out.println("Creating new chord overlay network!");
        }
        String bootStrap = (String)this.parameters.remove(BOOTSTRAP_PARAM);
        if (this.parameters.size() > 0) {
            StringBuilder msg = new StringBuilder();
            msg.append("Too many parameters. Unknown parameters: ");
            Iterator params = this.parameters.keySet().iterator();
            while (params.hasNext()) {
                msg.append((String)params.next());
                msg.append(" ");
            }
            throw new ConsoleException(msg.toString());
        }
        URL bootstrapURL = null;
        if (bootStrap != null) {
            try {
                bootstrapURL = new URL(URL.KNOWN_PROTOCOLS.get(RemoteChordNetworkAccess.getUniqueInstance().protocolType) + "://" + bootStrap + "/");
            }
            catch (MalformedURLException e) {
                throw new ConsoleException("URL " + bootStrap + " provided by " + BOOTSTRAP_PARAM + " parameter is malformed!", e);
            }
            this.out.println("Trying to join chord network with boostrap URL " + bootstrapURL);
        }
        RemoteChordNetworkAccess remote = (RemoteChordNetworkAccess)this.toCommand[1];
        try {
            remote.join(bootstrapURL, port);
        }
        catch (Exception e) {
            e.printStackTrace(this.out);
            throw new ConsoleException("Join/Creation of network failed. Reason: " + e.getMessage(), e);
        }
        this.out.println("URL of created chord node " + remote.getChordInstance().getURL() + ".");
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public void printOutHelp() {
        this.out.println("The joinN command creates a chord node \nto which remote nodes can connect.");
        this.out.println("______________");
        this.out.println("Parameters: ");
        this.out.println("'bootstrap' takes a part of an URL of a remote chord \nnode, that is then used as bootstrap node. \nIf no bootstrap node is provided a new chord network is created. \n The parameter must be in the form hostname:port");
    }
}

