/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console.command;

import de.uniba.wiai.lspi.chord.console.command.RemoteChordNetworkAccess;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.ConsoleException;
import java.io.PrintStream;

public class ChangeProtocol
extends Command {
    private static final String RMI_PROTOCOL = URL.KNOWN_PROTOCOLS.get(2);
    private static final String SOCKET_PROTOCOL = URL.KNOWN_PROTOCOLS.get(0);
    public static final String COMMAND_NAME = "cprotocol";
    private static final String TYPE_PARAM = "t";
    private static final String STATUS_PARAM = "s";

    public ChangeProtocol(Object[] toCommand, PrintStream out) {
        super(toCommand, out);
    }

    public void exec() throws ConsoleException {
        String type;
        if (this.parameters.containsKey(TYPE_PARAM) && (type = (String)this.parameters.get(TYPE_PARAM)) != null && type.length() > 0) {
            if (type.equalsIgnoreCase(RMI_PROTOCOL)) {
                RemoteChordNetworkAccess.getUniqueInstance().protocolType = 2;
            } else if (type.equalsIgnoreCase(SOCKET_PROTOCOL)) {
                RemoteChordNetworkAccess.getUniqueInstance().protocolType = 0;
            }
        }
        if (this.parameters.containsKey(STATUS_PARAM)) {
            int type2 = RemoteChordNetworkAccess.getUniqueInstance().protocolType;
            this.out.println("Current protocol: " + URL.KNOWN_PROTOCOLS.get(type2));
        }
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public void printOutHelp() {
        this.out.println("Changes the protocol for remote chord networks used for this console.");
        this.out.println("Currently supported protocols: {ocsocket, ocrmi}");
    }
}

