/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.com.rmi;

import de.uniba.wiai.lspi.chord.com.CommunicationException;
import de.uniba.wiai.lspi.chord.com.Endpoint;
import de.uniba.wiai.lspi.chord.com.Entry;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.com.Proxy;
import de.uniba.wiai.lspi.chord.com.RefsAndEntries;
import de.uniba.wiai.lspi.chord.com.rmi.RMIEndpoint;
import de.uniba.wiai.lspi.chord.com.rmi.RemoteNode;
import de.uniba.wiai.lspi.chord.com.rmi.RemoteNodeInfo;
import de.uniba.wiai.lspi.chord.com.rmi.RemoteRefsAndEntries;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.chord.data.URL;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RMIProxy
extends Proxy {
    private static final String NAME_IN_REGISTRY = "oc_endpoint_";
    private RemoteNode remoteNode;
    private URL localURL;
    private volatile boolean connected;
    private RMIEndpoint localEndpoint;

    RMIProxy(RemoteNodeInfo rNode, URL url) {
        super(rNode.getUrl());
        if (url == null) {
            throw new IllegalArgumentException("URL of local node must not be null!");
        }
        this.remoteNode = rNode.getRemoteNode();
        this.nodeID = rNode.getNodeID();
        this.localURL = url;
        this.connected = true;
        this.localEndpoint = (RMIEndpoint)Endpoint.getEndpoint(this.localURL);
    }

    RMIProxy(URL localURL, URL url) throws RemoteException, CommunicationException {
        super(url);
        if (url == null) {
            throw new IllegalArgumentException("URL of local node must not be null!");
        }
        this.localURL = localURL;
        try {
            this.remoteNode = (RemoteNode)LocateRegistry.getRegistry(url.getHost(), url.getPort()).lookup(NAME_IN_REGISTRY + url.toString());
        }
        catch (NotBoundException e) {
            throw new CommunicationException("Cannot find stub with name " + url.getHost(), e);
        }
        this.nodeID = this.remoteNode.getNodeID();
        this.connected = true;
        this.localEndpoint = (RMIEndpoint)Endpoint.getEndpoint(this.localURL);
    }

    public static RMIProxy create(URL localURL, URL url) throws CommunicationException {
        try {
            return new RMIProxy(localURL, url);
        }
        catch (RemoteException e) {
            throw new CommunicationException("Connection cannot be established!", e);
        }
    }

    RemoteNode getRemoteNode() {
        return this.remoteNode;
    }

    @Override
    public void disconnect() {
        this.connected = false;
    }

    public void testConnection() throws CommunicationException {
        if (!this.connected) {
            throw new CommunicationException("Not connected!");
        }
    }

    @Override
    public Node findSuccessor(ID key) throws CommunicationException {
        this.testConnection();
        try {
            RemoteNodeInfo info = this.remoteNode.findSuccessor(key);
            return new RMIProxy(info, this.localURL);
        }
        catch (RemoteException e) {
            throw new CommunicationException("Could not connect to " + this.nodeURL + "!", e);
        }
    }

    @Override
    public void insertEntry(Entry entryToInsert) throws CommunicationException {
        this.testConnection();
        try {
            this.remoteNode.insertEntry(entryToInsert);
        }
        catch (RemoteException e) {
            throw new CommunicationException("Could not connect to " + this.nodeURL + "!", e);
        }
    }

    @Override
    public void insertReplicas(Set<Entry> entries) throws CommunicationException {
        this.testConnection();
        try {
            this.remoteNode.insertReplicas(entries);
        }
        catch (RemoteException e) {
            throw new CommunicationException("Could not connect to " + this.nodeURL + "!", e);
        }
    }

    @Override
    public void leavesNetwork(Node predecessor) throws CommunicationException {
        this.testConnection();
        try {
            RemoteNodeInfo info = null;
            info = this.localURL.equals(predecessor.getNodeURL()) ? new RemoteNodeInfo(this.localEndpoint.getRemoteNode(), predecessor.getNodeID(), predecessor.getNodeURL()) : new RemoteNodeInfo(((RMIProxy)predecessor).remoteNode, predecessor.getNodeID(), predecessor.getNodeURL());
            this.remoteNode.leavesNetwork(info);
        }
        catch (RemoteException e) {
            throw new CommunicationException("Could not connect to " + this.getNodeURL() + "!", e);
        }
    }

    @Override
    public List<Node> notify(Node predecessor) throws CommunicationException {
        this.testConnection();
        try {
            RemoteNodeInfo info = null;
            info = this.localURL.equals(predecessor.getNodeURL()) ? new RemoteNodeInfo(this.localEndpoint.getRemoteNode(), predecessor.getNodeID(), predecessor.getNodeURL()) : new RemoteNodeInfo(((RMIProxy)predecessor).remoteNode, predecessor.getNodeID(), predecessor.getNodeURL());
            List<RemoteNodeInfo> infos = this.remoteNode.notify(info);
            LinkedList<Node> nodes = new LinkedList<Node>();
            for (RemoteNodeInfo i : infos) {
                nodes.add(new RMIProxy(i, this.localURL));
            }
            return nodes;
        }
        catch (RemoteException e) {
            throw new CommunicationException("Could not connect to " + this.nodeURL + "!", e);
        }
    }

    @Override
    public RefsAndEntries notifyAndCopyEntries(Node predecessor) throws CommunicationException {
        this.testConnection();
        try {
            RemoteNodeInfo info = null;
            info = this.localURL.equals(predecessor.getNodeURL()) ? new RemoteNodeInfo(this.localEndpoint.getRemoteNode(), predecessor.getNodeID(), predecessor.getNodeURL()) : new RemoteNodeInfo(((RMIProxy)predecessor).remoteNode, predecessor.getNodeID(), predecessor.getNodeURL());
            RemoteRefsAndEntries rraes = this.remoteNode.notifyAndCopyEntries(info);
            LinkedList<Node> nodes = new LinkedList<Node>();
            List<RemoteNodeInfo> infos = rraes.getNodeInfos();
            for (RemoteNodeInfo i : infos) {
                nodes.add(new RMIProxy(i, this.localURL));
            }
            RefsAndEntries raes = new RefsAndEntries(nodes, rraes.getEntries());
            return raes;
        }
        catch (RemoteException e) {
            throw new CommunicationException("Could not connect to " + this.nodeURL + "!", e);
        }
    }

    @Override
    public void ping() throws CommunicationException {
        this.testConnection();
        try {
            this.remoteNode.ping();
        }
        catch (RemoteException e) {
            throw new CommunicationException("Could not connect to " + this.nodeURL + "!", e);
        }
    }

    @Override
    public void removeEntry(Entry entryToRemove) throws CommunicationException {
        this.testConnection();
        try {
            this.remoteNode.removeEntry(entryToRemove);
        }
        catch (RemoteException e) {
            throw new CommunicationException("Could not connect to " + this.nodeURL + "!", e);
        }
    }

    @Override
    public void removeReplicas(ID sendingNode, Set<Entry> replicasToRemove) throws CommunicationException {
        this.testConnection();
        try {
            this.remoteNode.removeReplicas(sendingNode, replicasToRemove);
        }
        catch (RemoteException e) {
            throw new CommunicationException("Could not connect to " + this.nodeURL + "!", e);
        }
    }

    @Override
    public Set<Entry> retrieveEntries(ID id) throws CommunicationException {
        this.testConnection();
        try {
            return this.remoteNode.retrieveEntries(id);
        }
        catch (RemoteException e) {
            throw new CommunicationException("Could not connect to " + this.nodeURL + "!", e);
        }
    }
}

