/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.com.local;

import de.uniba.wiai.lspi.chord.com.CommunicationException;
import de.uniba.wiai.lspi.chord.com.Endpoint;
import de.uniba.wiai.lspi.chord.com.Entry;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.com.RefsAndEntries;
import de.uniba.wiai.lspi.chord.com.local.ChordImplAccess;
import de.uniba.wiai.lspi.chord.com.local.InvocationListener;
import de.uniba.wiai.lspi.chord.com.local.Registry;
import de.uniba.wiai.lspi.chord.com.local.ThreadProxy;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.chord.service.impl.ChordImpl;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadEndpoint
extends Endpoint {
    private Logger logger = null;
    private static final int CRASHED = Integer.MAX_VALUE;
    protected final Registry registry;
    private Object lock = new Object();
    protected List<InvocationListener> invocationListeners = null;

    public ThreadEndpoint(Node node1, URL url1) {
        super(node1, url1);
        this.logger = Logger.getLogger(ThreadEndpoint.class.getName() + "." + node1.getNodeID());
        this.invocationListeners = new LinkedList<InvocationListener>();
        this.registry = Registry.getRegistryInstance();
        this.logger.info(this + " initialised.");
    }

    public ID getNodeID() {
        return this.node.getNodeID();
    }

    public void register(InvocationListener listener) {
        this.logger.debug("register(" + listener + ")");
        this.invocationListeners.add(listener);
        this.logger.debug("No. of invocation listeners " + this.invocationListeners.size());
    }

    private void notifyInvocationListeners(int method) {
        for (InvocationListener l : this.invocationListeners) {
            l.notifyInvocationOf(method);
        }
    }

    private void notifyInvocationListenersFinished(int method) {
        for (InvocationListener l : this.invocationListeners) {
            l.notifyInvocationOfFinished(method);
        }
    }

    public Node findSuccessor(ID key) throws CommunicationException {
        this.checkIfCrashed();
        this.waitFor(1);
        this.notifyInvocationListeners(0);
        Node n = this.node.findSuccessor(key);
        if (n == this.node) {
            this.logger.debug("Returned node is local node. Converting to 'remote' reference. ");
            ThreadProxy t = new ThreadProxy(this.url, this.url);
            t.reSetNodeID(n.getNodeID());
            n = t;
        }
        this.notifyInvocationListenersFinished(0);
        return n;
    }

    public void insertEntry(Entry entry) throws CommunicationException {
        this.checkIfCrashed();
        this.waitFor(2);
        this.notifyInvocationListeners(1);
        this.node.insertEntry(entry);
        this.notifyInvocationListenersFinished(1);
    }

    public void removeEntry(Entry entry) throws CommunicationException {
        this.checkIfCrashed();
        this.waitFor(2);
        this.notifyInvocationListeners(7);
        this.node.removeEntry(entry);
        this.notifyInvocationListenersFinished(7);
    }

    public List<Node> notify(Node potentialPredecessor) throws CommunicationException {
        this.checkIfCrashed();
        this.waitFor(1);
        this.notifyInvocationListeners(4);
        this.logger.debug("Invoking notify on local node " + this.node);
        List<Node> n = this.node.notify(potentialPredecessor);
        this.logger.debug("Notify resulted in " + n);
        for (Node current : n) {
            if (current != this.node) continue;
            n.remove(current);
            this.logger.debug("Returned node is local node. Converting to 'remote' reference. ");
            n.add(new ThreadProxy(this.url, this.url));
        }
        this.notifyInvocationListenersFinished(4);
        return n;
    }

    public void ping() throws CommunicationException {
        this.checkIfCrashed();
        this.waitFor(1);
        this.notifyInvocationListeners(6);
        this.node.ping();
        this.notifyInvocationListenersFinished(6);
    }

    public Set<Entry> retrieveEntries(ID id) throws CommunicationException {
        this.checkIfCrashed();
        this.waitFor(2);
        this.notifyInvocationListeners(9);
        Set<Entry> s = this.node.retrieveEntries(id);
        this.notifyInvocationListenersFinished(9);
        return s;
    }

    public void leavesNetwork(Node predecessor) throws CommunicationException {
        this.checkIfCrashed();
        this.notifyInvocationListeners(3);
        this.node.leavesNetwork(predecessor);
        this.notifyInvocationListenersFinished(3);
    }

    public void removeReplicas(ID sendingNodeID, Set<Entry> entriesToRemove) throws CommunicationException {
        this.checkIfCrashed();
        this.waitFor(1);
        this.notifyInvocationListeners(8);
        this.node.removeReplicas(sendingNodeID, entriesToRemove);
        this.notifyInvocationListenersFinished(8);
    }

    public void insertReplicas(Set<Entry> entries) throws CommunicationException {
        this.checkIfCrashed();
        this.waitFor(1);
        this.notifyInvocationListeners(2);
        this.node.insertReplicas(entries);
        this.notifyInvocationListenersFinished(2);
    }

    public RefsAndEntries notifyAndCopyEntries(Node potentialPredecessor) throws CommunicationException {
        this.checkIfCrashed();
        this.waitFor(2);
        this.notifyInvocationListeners(5);
        RefsAndEntries refs = this.node.notifyAndCopyEntries(potentialPredecessor);
        List<Node> nodes = refs.getRefs();
        for (Node current : nodes) {
            if (current != this.node) continue;
            nodes.remove(current);
            this.logger.debug("Returned node is local node. Converting to 'remote' reference. ");
            nodes.add(new ThreadProxy(this.url, this.url));
        }
        this.notifyInvocationListenersFinished(5);
        return new RefsAndEntries(nodes, refs.getEntries());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(int state_) throws CommunicationException {
        Object object = this.lock;
        synchronized (object) {
            while (this.getState() < state_) {
                try {
                    this.logger.debug(Thread.currentThread() + " waiting for state: " + state_);
                    this.lock.wait();
                    if (state_ != Integer.MAX_VALUE) continue;
                    throw new CommunicationException("Connection destroyed!");
                }
                catch (InterruptedException t) {
                    this.logger.warn("Unexpected exception while waiting!", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitingThreads() {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug("Notifying waiting threads.");
            this.lock.notifyAll();
        }
    }

    @Override
    protected void openConnections() {
        this.logger.debug("openConnections()");
        this.notifyWaitingThreads();
        this.registry.bind(this);
    }

    @Override
    protected void closeConnections() {
        this.registry.unbind(this);
        this.registry.removeProxiesInUseBy(this.getURL());
        this.notifyWaitingThreads();
    }

    @Override
    protected void entriesAcceptable() {
        this.notifyWaitingThreads();
    }

    public void crash() {
        this.logger.debug("crash() invoked!");
        this.registry.unbind(this);
        List<ThreadProxy> proxies = this.registry.getProxiesInUseBy(this.getURL());
        if (proxies != null) {
            for (ThreadProxy p : proxies) {
                p.invalidate();
            }
        }
        this.registry.removeProxiesInUseBy(this.getURL());
        this.setState(Integer.MAX_VALUE);
        this.notifyWaitingThreads();
        ChordImpl impl = ChordImplAccess.fetchChordImplOfNode(this.node);
        Field[] fields = impl.getClass().getDeclaredFields();
        this.logger.debug(fields.length + " fields obtained from class " + impl.getClass());
        for (Field field : fields) {
            this.logger.debug("Examining field " + field + " of node " + this.node);
            try {
                if (!field.getName().equals("maintenanceTasks")) continue;
                field.setAccessible(true);
                Object executor = field.get(impl);
                this.logger.debug("Shutting down TaskExecutor " + executor + ".");
                Method m = executor.getClass().getMethod("shutdown", new Class[0]);
                m.setAccessible(true);
                m.invoke(executor, new Object[0]);
            }
            catch (Throwable t) {
                this.logger.warn("Could not kill threads of node " + this.node, t);
                t.printStackTrace();
            }
        }
        Endpoint.endpoints.remove(this.url);
        this.invocationListeners = null;
    }

    private void checkIfCrashed() throws CommunicationException {
        if (this.getState() == Integer.MAX_VALUE || this.getState() < 1) {
            this.logger.debug(this + " has crashed. Throwing Exception.");
            throw new CommunicationException();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ThreadEndpoint) {
            ThreadEndpoint ep = (ThreadEndpoint)obj;
            URL epURL = ep.getURL();
            return epURL.equals(this.getURL()) && ep.hashCode() == this.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[ThreadEndpoint for node ");
        buffer.append(this.node);
        buffer.append(" with URL ");
        buffer.append(this.url);
        buffer.append("]");
        return buffer.toString();
    }
}

