/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.com.local;

import de.uniba.wiai.lspi.chord.com.local.ThreadEndpoint;
import de.uniba.wiai.lspi.chord.com.local.ThreadProxy;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Registry {
    private static final Logger logger = Logger.getLogger(Registry.class.getName());
    private static Registry registry;
    private Map<URL, ThreadEndpoint> registeredEndpoints = new HashMap<URL, ThreadEndpoint>();
    private Map<URL, List<ThreadProxy>> proxiesInUse = new HashMap<URL, List<ThreadProxy>>();

    private Registry() {
    }

    public void addProxyUsedBy(URL url, ThreadProxy proxy) {
        if (!this.registeredEndpoints.containsKey(url)) {
            return;
        }
        List<ThreadProxy> pList = this.proxiesInUse.get(url);
        if (pList == null) {
            pList = new LinkedList<ThreadProxy>();
        }
        pList.add(proxy);
        this.proxiesInUse.put(url, pList);
    }

    public List<ThreadProxy> getProxiesInUseBy(URL nodeName) {
        logger.debug("getProxiesInUseBy(" + nodeName + ")");
        return this.proxiesInUse.get(nodeName);
    }

    public void removeProxiesInUseBy(URL nodeName) {
        logger.debug("removeProxiesInUseBy(" + nodeName + ")");
        this.proxiesInUse.remove(nodeName);
    }

    public void bind(ThreadEndpoint endpoint) {
        URL name = endpoint.getURL();
        logger.debug("Binding endpoint: " + endpoint + "with name " + name);
        ThreadEndpoint temp = this.registeredEndpoints.get(name);
        if (temp == null) {
            this.registeredEndpoints.put(name, endpoint);
            logger.debug("Endpoint " + endpoint + " bound.");
        } else {
            logger.warn("Endpoint " + endpoint + " NOT BOUND!!! " + temp + " already registered under " + name);
        }
    }

    public void unbind(ThreadEndpoint endpoint) {
        logger.debug("Unbinding endpoint: " + endpoint);
        this.registeredEndpoints.remove(endpoint.getURL());
        logger.debug("Endpoint " + endpoint + " removed from registry.");
    }

    public ThreadEndpoint lookup(URL url) {
        logger.debug("Looking up endpoint for " + url);
        ThreadEndpoint ep = this.registeredEndpoints.get(url);
        logger.debug("Endpoint for " + url + ": " + ep);
        return ep;
    }

    public Map<URL, ThreadEndpoint> lookupAll() {
        return this.registeredEndpoints;
    }

    public static Registry getRegistryInstance() {
        if (registry == null) {
            logger.debug("Creating registry singleton. ");
            registry = new Registry();
            logger.debug("Registry singleton created. ");
        }
        return registry;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[Singleton registry of ThreadEndpoints ");
        buffer.append("with ");
        buffer.append(this.registeredEndpoints.size());
        buffer.append(" endpoints registered]");
        return buffer.toString();
    }

    public void shutdown() {
        for (ThreadEndpoint endpoint : this.registeredEndpoints.values()) {
            endpoint.crash();
        }
    }
}

