/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.com.local;

import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.service.impl.ChordImpl;
import de.uniba.wiai.lspi.chord.service.impl.NodeImpl;
import java.lang.reflect.Field;

public class ChordImplAccess {
    private ChordImplAccess() {
    }

    public static ChordImpl fetchChordImplOfNode(Node n) {
        NodeImpl node = null;
        try {
            node = (NodeImpl)n;
        }
        catch (ClassCastException e) {
            ChordImplAccess.handleException(e);
        }
        Field chordImplField = null;
        try {
            chordImplField = node.getClass().getDeclaredField("impl");
        }
        catch (SecurityException e) {
            ChordImplAccess.handleException(e);
        }
        catch (NoSuchFieldException e) {
            ChordImplAccess.handleException(e);
        }
        chordImplField.setAccessible(true);
        ChordImpl impl = null;
        try {
            impl = (ChordImpl)chordImplField.get(node);
        }
        catch (IllegalArgumentException e) {
            ChordImplAccess.handleException(e);
        }
        catch (IllegalAccessException e) {
            ChordImplAccess.handleException(e);
        }
        return impl;
    }

    private static void handleException(Exception e) {
        System.err.println("This should not happen! This indicates that the implementation of service layer has changed. This code relies heavily on internal structure of service layer, as it was not possible to solve some problem with local communication by other means!");
        System.err.println("If this happens check if you can adapt this code our contact one of the developers!");
        e.printStackTrace();
        throw new RuntimeException(e);
    }
}

