/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.com;

import de.uniba.wiai.lspi.chord.com.EndpointStateListener;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.com.local.ThreadEndpoint;
import de.uniba.wiai.lspi.chord.com.rmi.RMIEndpoint;
import de.uniba.wiai.lspi.chord.com.socket.SocketEndpoint;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Endpoint {
    private static final Logger logger = Logger.getLogger(Endpoint.class);
    protected static final Map<URL, Endpoint> endpoints = new HashMap<URL, Endpoint>();
    public static final int STARTED = 0;
    public static final int LISTENING = 1;
    public static final int ACCEPT_ENTRIES = 2;
    public static final int DISCONNECTED = 3;
    public static final List<String> METHODS_ALLOWED_IN_ACCEPT_ENTRIES;
    private int state = -1;
    protected URL url;
    protected Node node;
    private Set<EndpointStateListener> listeners = new HashSet<EndpointStateListener>();

    protected Endpoint(Node node1, URL url1) {
        logger.info("Endpoint for " + node1 + " with url " + url1 + "created.");
        this.node = node1;
        this.url = url1;
        this.state = 0;
    }

    public final Node getNode() {
        return this.node;
    }

    public final void register(EndpointStateListener listener) {
        this.listeners.add(listener);
    }

    public final void deregister(EndpointStateListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notify(int s) {
        logger.debug("notifying state change.");
        Set<EndpointStateListener> set = this.listeners;
        synchronized (set) {
            logger.debug("Size of listeners = " + this.listeners.size());
            for (EndpointStateListener listener : this.listeners) {
                listener.notify(s);
            }
        }
    }

    public URL getURL() {
        return this.url;
    }

    public final int getState() {
        return this.state;
    }

    protected final void setState(int state1) {
        this.state = state1;
        this.notify(state1);
    }

    public final void listen() {
        this.state = 1;
        this.notify(this.state);
        this.openConnections();
    }

    protected abstract void openConnections();

    public final void acceptEntries() {
        logger.info("acceptEntries() called.");
        this.state = 2;
        this.notify(this.state);
        this.entriesAcceptable();
    }

    protected abstract void entriesAcceptable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect() {
        this.state = 0;
        logger.info("Disconnecting.");
        this.notify(this.state);
        this.closeConnections();
        Map<URL, Endpoint> map = endpoints;
        synchronized (map) {
            endpoints.remove(this.node.nodeURL);
        }
    }

    protected abstract void closeConnections();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Endpoint createEndpoint(Node node, URL url) {
        Map<URL, Endpoint> map = endpoints;
        synchronized (map) {
            if (endpoints.containsKey(url)) {
                throw new RuntimeException("Endpoint already created!");
            }
            Endpoint endpoint = null;
            if (url == null) {
                throw new IllegalArgumentException("Url must not be null! ");
            }
            if (url.getProtocol().equals(URL.KNOWN_PROTOCOLS.get(0))) {
                endpoint = new SocketEndpoint(node, url);
            } else if (url.getProtocol().equals(URL.KNOWN_PROTOCOLS.get(1))) {
                endpoint = new ThreadEndpoint(node, url);
            } else if (url.getProtocol().equals(URL.KNOWN_PROTOCOLS.get(2))) {
                endpoint = new RMIEndpoint(node, url);
            } else {
                throw new IllegalArgumentException("Url does not contain a supported protocol (" + url.getProtocol() + ")!");
            }
            endpoints.put(url, endpoint);
            return endpoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Endpoint getEndpoint(URL url) {
        Map<URL, Endpoint> map = endpoints;
        synchronized (map) {
            Endpoint ep = endpoints.get(url);
            logger.debug("Endpoint for URL " + url + ": " + ep);
            return ep;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[Endpoint for ");
        buffer.append(this.node);
        buffer.append(" with URL ");
        buffer.append(this.url);
        return buffer.toString();
    }

    static {
        Object[] temp = new String[]{"insertEntry", "removeEntry", "retrieveEntries"};
        Arrays.sort(temp);
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(temp));
        METHODS_ALLOWED_IN_ACCEPT_ENTRIES = Collections.unmodifiableList(list);
    }
}

