/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor.impl;

import dareka.processor.HttpRequestHeader;
import dareka.processor.Processor;
import dareka.processor.Resource;
import dareka.processor.impl.NicoRecordingWatchListener;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NicoRecordingWatchProcessor
implements Processor {
    private static final String[] SUPPORTED_METHODS = new String[]{"GET"};
    private static final Pattern SM_WATCH_PAGE_PATTERN = Pattern.compile("^http://www\\.nicovideo\\.jp/watch/([a-z]{2})?(\\d+)(?:\\?.*)?$");

    @Override
    public String[] getSupportedMethods() {
        return SUPPORTED_METHODS;
    }

    @Override
    public Pattern getSupportedURLAsPattern() {
        return SM_WATCH_PAGE_PATTERN;
    }

    @Override
    public String getSupportedURLAsString() {
        return null;
    }

    @Override
    public Resource onRequest(HttpRequestHeader requestHeader) throws IOException {
        String url = requestHeader.getURI();
        Matcher m = SM_WATCH_PAGE_PATTERN.matcher(url);
        if (!m.find()) {
            throw new IllegalStateException("unexpected url: " + url);
        }
        String type = m.group(1);
        String id = m.group(2);
        Resource r = Resource.get(Resource.Type.URL, url);
        NicoRecordingWatchListener l = new NicoRecordingWatchListener(type, id);
        r.addTransferListener(l);
        return r;
    }
}

