/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor.impl;

import dareka.common.Logger;
import dareka.processor.HttpRequestHeader;
import dareka.processor.Processor;
import dareka.processor.Resource;
import dareka.processor.impl.NicoIdInfoCache;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NicoRecordingUrlProcessor
implements Processor {
    private static final String[] SUPPORTED_METHODS = new String[]{"GET", "HEAD"};
    private static final Pattern TYPE_ID_URL_PATTERN = Pattern.compile("^http://(?:ext\\.nicovideo\\.jp/thumb(?:_watch)?|www\\.nicovideo\\.jp/api/getflv)/([a-z]{2})(\\d+)");

    @Override
    public String[] getSupportedMethods() {
        return SUPPORTED_METHODS;
    }

    @Override
    public Pattern getSupportedURLAsPattern() {
        return TYPE_ID_URL_PATTERN;
    }

    @Override
    public String getSupportedURLAsString() {
        return null;
    }

    @Override
    public Resource onRequest(HttpRequestHeader requestHeader) throws IOException {
        String url = requestHeader.getURI();
        Matcher m = TYPE_ID_URL_PATTERN.matcher(url);
        if (!m.find()) {
            throw new IllegalStateException("unexpected url: " + url);
        }
        String type = m.group(1);
        String id = m.group(2);
        NicoIdInfoCache.getInstance().putOnlyTypeAndId(type, id);
        Logger.debugWithThread("type recorded: " + id + " => " + type);
        Resource r = Resource.get(Resource.Type.URL, url);
        return r;
    }
}

