/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor;

import dareka.common.CloseUtil;
import dareka.common.Config;
import dareka.common.HttpIOException;
import dareka.processor.HostportResource;
import dareka.processor.HttpHeader;
import dareka.processor.HttpMessageHeaderHolder;
import dareka.processor.HttpRequestHeader;
import dareka.processor.HttpResponseHeader;
import dareka.processor.HttpUtil;
import dareka.processor.StringResource;
import dareka.processor.TransferListener;
import dareka.processor.URLResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Resource {
    protected static final int BUF_SIZE = 32768;
    private Set<TransferListener> listeners = new HashSet<TransferListener>();
    private HttpMessageHeaderHolder explicitHeaders = new HttpMessageHeaderHolder();
    private boolean onTransferEndFired = false;

    public static Resource get(Type type, String resource) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("resource must not be null");
        }
        if (type == Type.URL) {
            return new URLResource(resource);
        }
        if (type == Type.STRING) {
            return new StringResource(resource);
        }
        if (type == Type.HOSTPORT) {
            return new HostportResource(resource);
        }
        throw new IllegalArgumentException("invalid type: " + (Object)((Object)type));
    }

    public void addTransferListener(TransferListener l) {
        if (l == null) {
            throw new IllegalArgumentException("TransferListener must not be null");
        }
        this.listeners.add(l);
    }

    public void setResponseHeader(String key, String value) {
        this.explicitHeaders.put(key, value);
    }

    public void addResponseHeader(String key, String value) {
        this.explicitHeaders.add(key, value);
    }

    public boolean transferTo(Socket receiver, HttpRequestHeader requestHeader, Config config) throws IOException {
        try {
            boolean bl = this.endEnsuredTransferTo(receiver, requestHeader, config);
            return bl;
        }
        finally {
            this.fireOnTransferEnd(false);
        }
    }

    protected boolean endEnsuredTransferTo(Socket receiver, HttpRequestHeader requestHeader, Config config) throws IOException {
        return false;
    }

    protected int getListenersSize() {
        return this.listeners.size();
    }

    protected void fireOnResonseHeader(HttpResponseHeader responseHeader) {
        for (TransferListener l : this.listeners) {
            l.onResponseHeader(responseHeader);
        }
    }

    protected void fireOnTransferBegin(OutputStream receiverOut) {
        for (TransferListener l : this.listeners) {
            l.onTransferBegin(receiverOut);
        }
    }

    protected void fireOnTransferring(byte[] buf, int length) {
        for (TransferListener l : this.listeners) {
            l.onTransferring(buf, length);
        }
    }

    protected void fireOnTransferEnd(boolean completed) {
        if (this.onTransferEndFired) {
            return;
        }
        this.onTransferEndFired = true;
        for (TransferListener l : this.listeners) {
            l.onTransferEnd(completed);
        }
    }

    protected void execSendingHeaderSequence(OutputStream out, HttpResponseHeader responseHeader) throws IOException {
        this.overrideResponseMessage(responseHeader);
        this.doSetMandatoryResponseHeader(responseHeader);
        this.fireOnResonseHeader(responseHeader);
        HttpUtil.sendHeader(out, (HttpHeader)responseHeader);
    }

    protected void execSendingBodySequence(OutputStream out, InputStream in, long contentLength) throws IOException {
        long transferredLength = this.transfer(out, in);
        if (contentLength != -1L && transferredLength != contentLength) {
            throw new HttpIOException("inconsistent content length: header=" + contentLength + " actual=" + transferredLength);
        }
    }

    private void overrideResponseMessage(HttpResponseHeader responseHeader) {
        for (Map.Entry<String, List<String>> entry : this.explicitHeaders.entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            responseHeader.removeMessageHeader(key);
            for (String value : values) {
                responseHeader.addMessageHeader(key, value);
            }
        }
    }

    protected void doSetMandatoryResponseHeader(HttpResponseHeader responseHeader) {
    }

    private long transfer(OutputStream out, InputStream in) throws IOException {
        byte[] buf = new byte[32768];
        long transferredLength = 0L;
        if (this.getListenersSize() == 0) {
            int len;
            while ((len = in.read(buf)) != -1) {
                try {
                    out.write(buf, 0, len);
                    transferredLength += (long)len;
                }
                catch (IOException e) {
                    CloseUtil.close(out);
                    throw e;
                }
            }
        } else {
            int len;
            this.fireOnTransferBegin(out);
            while ((len = in.read(buf)) != -1) {
                this.fireOnTransferring(buf, len);
                try {
                    out.write(buf, 0, len);
                    transferredLength += (long)len;
                }
                catch (IOException e) {
                    this.fireOnTransferEnd(false);
                    CloseUtil.close(out);
                    throw e;
                }
            }
            this.fireOnTransferEnd(true);
        }
        return transferredLength;
    }

    protected boolean isClientCanKeepAlive(HttpRequestHeader requestHeader) {
        String connection = requestHeader.getMessageHeader("Connection");
        return !(requestHeader.getVersion().equals("HTTP/1.0") ? connection == null : connection != null && connection.equalsIgnoreCase("close"));
    }

    public static enum Type {
        URL,
        STRING,
        HOSTPORT;

    }
}

