/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor;

import dareka.common.HttpIOException;
import dareka.processor.HttpHeader;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpRequestHeader
extends HttpHeader {
    private static final Pattern PROXY_REQUEST_LINE_PATTERN = Pattern.compile("^([A-Z]+) ((?:http://)?([^/:]+)(?::(\\d+))?(/\\S*)?) (HTTP/1\\.[01])\r\n");
    private String method;
    private String uri;
    private String host;
    private int port;
    private String path;
    private String version;

    public HttpRequestHeader(InputStream source) throws IOException {
        super(source);
        this.init();
    }

    public HttpRequestHeader(String source) throws IOException {
        super(source);
        this.init();
    }

    private void init() throws HttpIOException {
        Matcher m = PROXY_REQUEST_LINE_PATTERN.matcher(this.getStartLine());
        if (!m.find()) {
            throw new HttpIOException("invalid request:\r\n" + super.toString());
        }
        this.method = m.group(1);
        this.uri = m.group(2);
        this.host = m.group(3);
        this.port = m.group(4) == null ? 80 : Integer.parseInt(m.group(4));
        this.path = m.group(5) == null ? "" : m.group(5);
        this.version = m.group(6);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
        this.updateStartLine();
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
        this.updateStartLine();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this.updateStartLine();
    }

    public void replaceUriWithPath() {
        if ("GET".equals(this.method) || "POST".equals(this.method)) {
            this.uri = this.path;
            this.updateStartLine();
        }
    }

    private void updateStartLine() {
        this.setStartLine(String.valueOf(this.method) + " " + this.uri + " " + this.version + "\r\n");
    }
}

