/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor;

import dareka.common.CloseUtil;
import dareka.common.Config;
import dareka.common.HttpIOException;
import dareka.processor.HttpHeader;
import dareka.processor.HttpRequestHeader;
import dareka.processor.HttpResponseHeader;
import dareka.processor.HttpUtil;
import dareka.processor.Resource;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostportResource
extends Resource {
    private static final Pattern HOSTPORT_PATTERN = Pattern.compile("^([^:]+):(\\d+)$");
    private InetSocketAddress host;

    public HostportResource(String resource) throws HttpIOException {
        Matcher m = HOSTPORT_PATTERN.matcher(resource);
        if (!m.find()) {
            throw new HttpIOException("invalid hostport: " + resource);
        }
        this.host = new InetSocketAddress(m.group(1), Integer.parseInt(m.group(2)));
    }

    @Override
    public boolean transferTo(Socket receiver, HttpRequestHeader requestHeader, Config config) throws IOException {
        SocketChannel sc = this.getServerChannelForConnect();
        try {
            this.handleConnectOnChannel(sc, receiver.getChannel());
        }
        finally {
            CloseUtil.close(sc);
        }
        return false;
    }

    @Override
    protected void doSetMandatoryResponseHeader(HttpResponseHeader responseHeader) {
        responseHeader.setMessageHeader("Connection", "close");
    }

    private SocketChannel getServerChannelForConnect() throws IOException {
        SocketChannel sc = SocketChannel.open();
        try {
            String proxyHost = System.getProperty("proxyHost");
            int proxyPort = Integer.getInteger("proxyPort");
            if (!Boolean.getBoolean("proxySSL") || proxyHost.equals("")) {
                sc.connect(this.host);
            } else {
                Socket proxy = sc.socket();
                proxy.connect(new InetSocketAddress(proxyHost, proxyPort));
                HttpRequestHeader requestHeader = new HttpRequestHeader("CONNECT " + this.host.getHostName() + ":" + this.host.getPort() + " HTTP/1.1\r\n\r\n");
                requestHeader.setMessageHeader("Connection", "close");
                HttpUtil.sendHeader(proxy, (HttpHeader)requestHeader);
                HttpResponseHeader responseHeader = new HttpResponseHeader(proxy.getInputStream());
                if (responseHeader.getStatusCode() != 200) {
                    throw new HttpIOException("failed to connect: " + responseHeader.toString());
                }
            }
        }
        catch (IOException e) {
            CloseUtil.close(sc);
            throw e;
        }
        catch (RuntimeException e) {
            CloseUtil.close(sc);
            throw e;
        }
        return sc;
    }

    private void handleConnectOnChannel(SocketChannel sc, SocketChannel bc) throws IOException {
        HttpResponseHeader responseHeader = new HttpResponseHeader("HTTP/1.1 200 Connection established\r\n\r\n");
        this.execSendingHeaderSequence(bc.socket().getOutputStream(), responseHeader);
        sc.configureBlocking(false);
        bc.configureBlocking(false);
        Selector sel = Selector.open();
        try {
            SelectionKey scKey = sc.register(sel, 1);
            SelectionKey bcKey = bc.register(sel, 1);
            scKey.attach(bc);
            bcKey.attach(sc);
            this.handleConnectOnSelector(sel);
        }
        finally {
            CloseUtil.close(sel);
        }
    }

    private void handleConnectOnSelector(Selector sel) throws IOException {
        int selcount;
        ByteBuffer bbuf = ByteBuffer.allocate(32768);
        while ((selcount = sel.selectNow()) >= 0 && sel.keys().size() > 0 && (selcount > 0 || sel.select() >= 0)) {
            Set<SelectionKey> selKeys = sel.selectedKeys();
            Iterator<SelectionKey> ite = selKeys.iterator();
            while (ite.hasNext()) {
                int len;
                SelectionKey key = ite.next();
                ite.remove();
                SocketChannel readCh = (SocketChannel)key.channel();
                SocketChannel writeCh = (SocketChannel)key.attachment();
                bbuf.clear();
                try {
                    len = readCh.read(bbuf);
                }
                catch (IOException e) {
                    len = -1;
                }
                if (len == -1) {
                    key.cancel();
                    writeCh.socket().shutdownOutput();
                    continue;
                }
                bbuf.flip();
                while (bbuf.hasRemaining()) {
                    writeCh.write(bbuf);
                }
            }
        }
    }
}

