/*
 * Decompiled with CFR 0.152.
 */
package dareka.dht;

import dareka.common.Config;
import dareka.common.Logger;
import dareka.dht.DataServer;
import dareka.dht.StringKey;
import dareka.processor.HttpResponseHeader;
import dareka.processor.URLResource;
import dareka.processor.impl.NicoApiUtil;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.chord.service.Key;
import de.uniba.wiai.lspi.chord.service.PropertiesLoader;
import de.uniba.wiai.lspi.chord.service.impl.ChordImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sbbi.upnp.impls.InternetGatewayDevice;

public class DHTManager {
    private boolean connected;
    private ChordImpl chord;
    private static DHTManager instance = new DHTManager();
    private String globalIP;
    private int ringPort;
    private int dataPort;
    private DataServer dataServer;
    private Map<Key, String> distributedMap = new HashMap<Key, String>();
    private InternetGatewayDevice igd;

    static {
        PropertiesLoader.loadPropertyFile();
    }

    private DHTManager() {
    }

    public static DHTManager getInstance() {
        return instance;
    }

    public void connect() throws Exception {
        if (Config.getBoolean("dhtUPnP", true)) {
            try {
                InternetGatewayDevice[] IGDs = InternetGatewayDevice.getDevices(5000);
                if (IGDs != null) {
                    this.igd = IGDs[0];
                    Logger.info("UPnP Found device: " + this.igd.getIGDRootDevice().getModelName());
                    Logger.info("UPnP fetch global IP: " + this.igd.getExternalIPAddress());
                    this.globalIP = this.igd.getExternalIPAddress();
                } else {
                    Logger.warning("UPnP unable to find device");
                }
            }
            catch (Exception e) {
                Logger.warning("UPnP error");
                Logger.error(e);
            }
        }
        if (this.globalIP == null) {
            this.globalIP = Config.getString("dhtGlobalIP", null);
        }
        if (this.globalIP == null) {
            Logger.warning("Please set dhtGlobalIP to config.properties");
            throw new Exception();
        }
        this.ringPort = Config.getInteger("dhtRingPort", 9800);
        this.dataPort = Config.getInteger("dhtDataPort", 9801);
        if (this.igd != null) {
            String localHostIP = InetAddress.getLocalHost().getHostAddress();
            boolean mapped = this.igd.addPortMapping("Genkidama ring", null, this.ringPort, this.ringPort, localHostIP, 0, "TCP");
            if (mapped) {
                Logger.info("UPnP port " + this.ringPort + " mapped to " + localHostIP);
            } else {
                Logger.info("UPnP port " + this.ringPort + " map failed");
            }
            mapped = this.igd.addPortMapping("Genkidama data", null, this.dataPort, this.dataPort, localHostIP, 0, "TCP");
            if (mapped) {
                Logger.info("UPnP port " + this.dataPort + " mapped to " + localHostIP);
            } else {
                Logger.info("UPnP port " + this.dataPort + " map failed");
            }
        }
        URL localURL = new URL("ocsocket://" + this.globalIP + ":" + this.ringPort + "/");
        this.chord = new ChordImpl();
        if (Config.getBoolean("dhtBootstrap", false)) {
            this.chord.create(localURL);
            Logger.info("DHT network created");
        } else {
            URL bootstrapURL = new URL(Config.getString("dhtBootstrapURL", null));
            this.chord.join(localURL, bootstrapURL);
            Logger.info("DHT network joined via " + bootstrapURL);
        }
        this.dataServer = new DataServer();
        this.dataServer.bind(this.dataPort);
        this.connected = true;
    }

    public String getNicoCache(String id) {
        if (!DHTManager.checkDeleted(id)) {
            StringKey key = new StringKey("nc2:" + id);
            Set<Serializable> uriList = this.chord.retrieve(key);
            for (Serializable s : uriList) {
                String uri = (String)((Object)s);
                try {
                    java.net.URL url = new java.net.URL(uri);
                    if (url.getHost().equals(this.globalIP)) continue;
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("HEAD");
                    conn.setConnectTimeout(Config.getInteger("dhtTimeout", 1000));
                    conn.connect();
                    conn.disconnect();
                    Logger.info("DHT get: nc2:" + id + " success");
                    return uri;
                }
                catch (Exception e) {
                    Logger.debug(e);
                    this.chord.remove(key, (Serializable)((Object)uri));
                }
            }
        }
        Logger.info("DHT get: nc2:" + id + " failed");
        return null;
    }

    public void putNicoCache(String id) {
        if (!DHTManager.checkDeleted(id)) {
            StringKey key = new StringKey("nc2:" + id);
            Logger.info("DHT put: nc2:" + id);
            String uri = "http://" + this.globalIP + ":" + this.dataPort + "/nc2/" + id;
            this.chord.insert(key, (Serializable)((Object)uri));
            this.distributedMap.put(key, uri);
        }
    }

    public static boolean checkDeleted(String id) {
        id = id.replaceAll("low$", "");
        String title = null;
        try {
            String url = NicoApiUtil.getThumbURL(id);
            URLResource r = new URLResource(url);
            r.setFollowRedirects(true);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            r.transferTo(null, bout, null, null);
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            new HttpResponseHeader(bin);
            title = NicoApiUtil.getThumbTitle(bin);
            bout.close();
            bin.close();
        }
        catch (Exception e) {
            Logger.error(e);
            e.printStackTrace();
        }
        if (title == null) {
            Logger.info("DHT cacheDeleted: " + id + " -> true");
            return true;
        }
        Logger.info("DHT cacheDeleted: " + id + " -> false");
        return false;
    }

    public void disconnect() {
        for (Map.Entry<Key, String> entry : this.distributedMap.entrySet()) {
            Logger.info("DHT remove: " + entry.getValue());
            this.chord.remove(entry.getKey(), (Serializable)((Object)entry.getValue()));
        }
        this.chord.leave();
        Logger.info("DHT network disconnected");
        if (this.igd != null) {
            try {
                boolean unmapped = this.igd.deletePortMapping(null, this.ringPort, "TCP");
                if (unmapped) {
                    Logger.info("UPnP port " + this.ringPort + " unmapped");
                }
                if (unmapped = this.igd.deletePortMapping(null, this.dataPort, "TCP")) {
                    Logger.info("UPnP port " + this.dataPort + " unmapped");
                }
            }
            catch (Exception e) {
                Logger.warning("UPnP error");
                Logger.debug(e);
            }
        }
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }
}

