/*
 * Decompiled with CFR 0.152.
 */
package dareka;

import dareka.ConnectionManager;
import dareka.common.CloseUtil;
import dareka.common.Config;
import dareka.common.Logger;
import dareka.processor.Processor;
import dareka.processor.impl.ConnectProcessor;
import dareka.processor.impl.GetPostProcessor;
import dareka.processor.impl.NicoCachingProcessor;
import dareka.processor.impl.NicoRecordingUrlProcessor;
import dareka.processor.impl.NicoRecordingWatchProcessor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class Server {
    private static final int MAX_WAITING_TIME = 10;
    private Config config;
    private ServerSocket serverSocket;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private boolean stopped = false;
    private Processor connectProcessor = new ConnectProcessor();
    private Processor getPostProcessor = new GetPostProcessor();
    private Processor nicoRecordingWatchProcessor = new NicoRecordingWatchProcessor();
    private Processor nicoRecordingUrlProcessor = new NicoRecordingUrlProcessor();

    public Server(Config config) throws IOException {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        this.config = config;
        ServerSocketChannel serverCh = ServerSocketChannel.open();
        this.serverSocket = serverCh.socket();
    }

    public void start() {
        if (this.stopped) {
            return;
        }
        try {
            this.bindServerSocket();
            this.acceptServerSocket();
        }
        finally {
            Logger.info("finalizing");
            this.cleanupServerSocket();
            this.cleanupExecutor();
        }
    }

    public synchronized void stop() {
        this.stopped = true;
        if (!this.serverSocket.isClosed()) {
            CloseUtil.close(this.serverSocket);
        }
        this.executor.shutdown();
    }

    private void bindServerSocket() {
        try {
            this.serverSocket.bind(new InetSocketAddress(InetAddress.getByName(null), (int)Integer.getInteger("listenPort")));
        }
        catch (Exception e) {
            Logger.error(e);
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptServerSocket() {
        try {
            boolean timeoutSupportedOrUnknown = true;
            int timeout = Config.getInteger("readTimeout", 600000);
            while (!this.stopped) {
                Socket client = this.serverSocket.accept();
                try {
                    if (timeoutSupportedOrUnknown) {
                        client.setSoTimeout(timeout);
                        if (client.getSoTimeout() != timeout) {
                            Logger.warning("read timeout is not suported");
                            timeoutSupportedOrUnknown = false;
                        }
                    }
                    Server server = this;
                    synchronized (server) {
                        if (this.stopped) {
                            break;
                        }
                        ConnectionManager worker = new ConnectionManager(this.config, client);
                        this.registerProcessor(new NicoCachingProcessor(this.executor), worker);
                        this.registerProcessor(this.nicoRecordingUrlProcessor, worker);
                        this.registerProcessor(this.nicoRecordingWatchProcessor, worker);
                        this.registerProcessor(this.getPostProcessor, worker);
                        this.registerProcessor(this.connectProcessor, worker);
                        this.executor.execute(worker);
                    }
                }
                catch (Exception e) {
                    Logger.error(e);
                    CloseUtil.close(client);
                }
            }
        }
        catch (IOException e) {
            Logger.debug(e);
        }
    }

    private void registerProcessor(Processor processor, ConnectionManager worker) {
        String[] methods;
        String url;
        Pattern p = processor.getSupportedURLAsPattern();
        if (p == null && (url = processor.getSupportedURLAsString()) != null) {
            p = Pattern.compile(url, 16);
        }
        if ((methods = processor.getSupportedMethods()) == null) {
            return;
        }
        String[] stringArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String method = stringArray[n2];
            worker.addProcessor(method, p, processor);
            ++n2;
        }
    }

    private void cleanupServerSocket() {
        if (!this.serverSocket.isClosed()) {
            CloseUtil.close(this.serverSocket);
        }
    }

    private void cleanupExecutor() {
        int i = 0;
        while (i < 10 && !this.executor.isTerminated()) {
            try {
                Logger.debug("waiting for terminating threads...");
                this.executor.shutdownNow();
                if (this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    Logger.debug("done");
                    break;
                }
                Logger.debug("timed out");
            }
            catch (InterruptedException e) {
                Logger.warning(e.toString());
            }
            ++i;
        }
    }
}

