/** @file
 */
#if !defined(__HYPERESTRAIER__WRAPPER__HPP__)
#define __HYPERESTRAIER__WRAPPER__HPP__

#include <boost/noncopyable.hpp>

namespace hyperestraier {

  namespace detail {
    template <typename HANDLE_TYPE> void raw_handle_deleter(HANDLE_TYPE*);
  }



  template <typename HANDLE_TYPE, typename DERIVED>
  class handle_wrapper :
    public boost::noncopyable
  {
  private:
    //inline handle_wrapper<HANDLE_TYPE, DERIVED>& operator =(handle_wrapper<HANDLE_TYPE, DERIVED> const& p);
    
  public:
    typedef HANDLE_TYPE    raw_handle_type;

  protected:
    raw_handle_type*       raw_handle_;

  public:
    handle_wrapper() : raw_handle_(0) { }
    explicit handle_wrapper(raw_handle_type* p) : raw_handle_(p) { }
    ~handle_wrapper() { clear(); }

    inline raw_handle_type* raw_handle() const { return raw_handle_; }
    inline void             set_raw_handle(raw_handle_type* p) {
      clear();
      raw_handle_ = p;
    }
    inline operator bool() const { return raw_handle_ != 0; }
    inline bool operator !() const { return raw_handle_ == 0; }
    inline void clear() {
      raw_handle_type* p = raw_handle_;
      raw_handle_ = 0;
      if (p)
        hyperestraier::detail::raw_handle_deleter(p);
    }

#if 0
    inline DERIVED& operator =(raw_handle_type* p) {
      clear();
      raw_handle_ = p;
      return *static_cast<DERIVED*>(this);
    }
#endif
  };
}

#endif
