/** @file
 */
#if defined(__GDESTRAIER__RESULTVIEW__HPP__)
#define __GDESTRAIER__RESULTVIEW__HPP__

#include <ctime>
#include <list>
#include <utility>

#include <boost/assert.hpp>

#include <glibmm/ustring.h>
#include <glibmm/refptr.h>
#include <gtkmm/treestore.h>

#include "model/index.hpp"
#include "model/timestamp.hpp"

namespace gdestraier {
  namespace gui {


    /** @class
     * 検索結果ビューに表示すべき文書を表すクラス
     */
    class result_document {
    protected:
#if !defined(NDEBUG)
      bool              is_copy_;
#endif

    public:
      Glib::ustring             uri_;
      Glib::ustring             mime_type_;
      char const*               mime_type_desc_; // コピーでは無いので破棄してはいけない
      Glib::ustring             title_;
      Glib::ustring             author_;
      Glib::ustring             language_;
      Glib::ustring             last_modified_;
      std::time_t               last_modified_time_;

      Glib::RefPtr<Gdk::Pixbuf> thumbnail_;
      bool                      cannt_thumbnail_;

      gdestraier::model::index_type const* index_;
      std::auto_ptr<char>       snippet_;
      Glib::ustring             markup_cache_;

      int                       score_;

      Gtk::TreeStore::iterator  tree_iter_;

    public:

      result_document() : cannt_thumbnail_(false), index_(0) {
#if !defined(NDEBUG)
        is_copy_ = false;
#endif
      }

      result_document(result_document const& r) {
#if !defined(NDEBUG)
        is_copy_ = false;
#endif
        *this = r;
      }


      result_document& operator=(result_document const& r) {
        /* コピーをする必要があるのは、最初にコンテナに突っ込む時だけ。 */
        // List の sort がコピー不要である事に依存してるんだけど大丈夫だよね？
#if !defined(NDEBUG)
        // 万一コピーされると、パフォーマンス上の問題も出るのでassertしておく
        BOOST_ASSERT(is_copy_ == false && r.is_copy_ == false && "result_document was copied.");
        is_copy_ = true;
#endif

        cannt_thumbnail_ = false;
        index_ = 0;

        return *this;
      }

      inline Glib::ustring const& get_mime_type() const { return mime_type_; }
      inline char const*          get_mime_type_desc() const { return mime_type_desc_; }
      inline Glib::ustring const& get_author() const { return author_; }
      inline Glib::ustring const& get_language() const { return language_; }
      inline gdestraier::model::index_type const* get_index() const { return index_; }

      inline int get_score() const { return score_; }

      inline Glib::ustring get_age(std::time_t now) const {
        return gdestraier::timestamp::to_age(now,
                                             last_modified_time_); // エラーの場合 epoc - 1 として処理させるから検査不要
      }
      inline std::time_t   get_last_modified_time() const { return last_modified_time_; }

      inline std::string const& get_index_name() const { return index_->description_; }
    };

  }
}


#endif


