/** @file
 */
#if defined(HAVE_CONFIG_H)
#  include "../../config.h"
#endif

#include <glibmm/spawn.h>

#include "powerpoint_filter.hpp"

namespace gdestraier {
  namespace builder {
    namespace filter {

      from_PowerPoint::from_PowerPoint()
      {
      }

      from_PowerPoint::~from_PowerPoint()
      {
      }

      factory::extention_map_type from_PowerPoint::extentions_[] = {
        { "ppt", "application/vnd.ms-powerpoint" },
        { "pps", "application/vnd.ms-powerpoint" },
        { 0, 0 }
      };

      factory const& from_PowerPoint::get_factory() {
        static factory f("PowerPoint", &from_PowerPoint::create, from_PowerPoint::extentions_);
        return f;
      }

      abstract_filter* from_PowerPoint::create() { return new from_PowerPoint; }

      bool from_PowerPoint::operator()(hyperestraier::local_document* doc,
                                       gdestraier::model::index_type const& index,
                                       ::GnomeVFSURI* uri,
                                       char const* text_uri,
                                       ::GnomeVFSFileInfo* info,
                                       char const* mime_type) const
      {
        // ローカルファイルで無い場合は、Unknown として処理
        char* local_path = get_local_path_from_uri(uri, text_uri);
        if (local_path == 0) {
          doc->create();
          doc->set_attr(ESTDATTRTYPE, (mime_type? mime_type : "application/vnd.ms-powerpoint"));
          return true;
        }


        std::list<std::string> args;
        args.push_back("ppthtml");
        args.push_back(local_path); ::g_free(local_path);

        std::string out;
        try {
          Glib::spawn_sync("/",
                           args,
                           Glib::SpawnFlags(Glib::SPAWN_SEARCH_PATH),
                           sigc::slot<void>(),
                           &out, 0, 0);
        }
        catch (Glib::SpawnError e) {
          g_warning("estcmd spawn error: %s", e.what().c_str());
          return false ;
        }

        doc->create();
        doc->set_attr(ESTDATTRTYPE, mime_type? mime_type : "application/vnd.ms-powerpoint");

        std::string::size_type n = out.size();
        char const* p = out.c_str();
        return parse_html(p, p + n, index, doc);
      }

    }
  }
}
