/** @file
 */
#if defined(HAVE_CONFIG_H)
#  include "../../config.h"
#endif

#include <glibmm/spawn.h>

#include "pdf_filter.hpp"

namespace gdestraier {
  namespace builder {
    namespace filter {

      from_PDF::from_PDF()
      {
      }

      from_PDF::~from_PDF()
      {
      }

      factory::extention_map_type from_PDF::extentions_[] = {
        { "pdf", "application/pdf" },
        { 0, 0 }
      };

      factory const& from_PDF::get_factory() {
        static factory f("PDF", &from_PDF::create, from_PDF::extentions_);
        return f;
      }

      abstract_filter* from_PDF::create() { return new from_PDF; }

      bool from_PDF::operator()(hyperestraier::local_document* doc,
                                gdestraier::model::index_type const& index,
                                ::GnomeVFSURI* uri,
                                char const* text_uri,
                                ::GnomeVFSFileInfo* info,
                                char const* mime_type) const
      {
        // ローカルファイルで無い場合は、Unknown として処理
        char* local_path = get_local_path_from_uri(uri, text_uri);
        if (local_path == 0) {
          doc->create();
          doc->set_attr(ESTDATTRTYPE, (mime_type? mime_type : "application/pdf"));
          return true;
        }


        std::list<std::string> args;
        args.push_back("pdftotext");
        args.push_back("-enc"); args.push_back("UTF-8");
        args.push_back("-htmlmeta");
        args.push_back("-nopgbrk");
        args.push_back(local_path); ::g_free(local_path);
        args.push_back("-");

        std::string out;
        try {
          Glib::spawn_sync("/",
                           args,
                           Glib::SpawnFlags(Glib::SPAWN_SEARCH_PATH),
                           sigc::slot<void>(),
                           &out, 0, 0);
        }
        catch (Glib::SpawnError e) {
          ::g_warning("estcmd spawn error: %s", e.what().c_str());
          return false ;
        }


        doc->create();
        doc->set_attr(ESTDATTRTYPE, (mime_type? mime_type : "application/pdf"));

        std::string::size_type n = out.size();
        char const* p = out.c_str();
        return parse_html(p, p + n, index, doc);
      }

    }
  }
}
