/** @file
 */
#if !defined(__GDESTRAIER__BUILDER__HTML_FILTER__HPP__)
#define __GDESTRAIER__BUILDER__HTML_FILTER__HPP__

#include "filter.hpp"

namespace gdestraier {
  namespace builder {
    namespace filter {

      struct html_parser {
        virtual ~html_parser() { }

        virtual bool on_start_element(char const* name_first, char const* name_last, bool empty_tag) { return true; }
        virtual bool on_end_element(char const* name_first, char const* name_last) { return true; }
        virtual bool on_attribute(char const* name_first, char const* name_last,
                                  char const* value_first, char const* value_last) { return true; }
        virtual bool on_text(char const* first, char const* last) { return true; }

        void parse(char const* first, char const* last);
      };


      class from_html : public abstract_filter
      {
      protected:

      public:
        from_html();
        virtual ~from_html();

        virtual bool operator()(hyperestraier::local_document* doc,
                                gdestraier::model::index_type const& index,
                                ::GnomeVFSURI* uri,
                                char const* text_uri,
                                ::GnomeVFSFileInfo* info,
                                char const* mime_type) const;

        static factory const& get_factory();
        static abstract_filter* create();

      protected:
        bool parse_html(char const* first, char const* last,
                        gdestraier::model::index_type const& index,
                        hyperestraier::local_document* doc) const;

        static factory::extention_map_type extentions_[];
      };

    }
  }
}


#endif
