# -*- coding: ascii -*-
#
#  messagesender.py - Any message send part of GBottler
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: messagesender.py,v 1.4 2004/09/29 21:58:11 atzm Exp $
#

import gtk
import os, sys, time
from threading import Thread
from common import *

from bottlelib import BottleClientError

if os.name == 'posix':
	import fcntl
else:
	import msvcrt

class VoteMessageSender(Thread):
	def __init__(self, client, logwindow, mid, type):
		self.client    = client
		self.logwindow = logwindow
		self.mid       = mid
		self.type      = type
		Thread.__init__(self)

	def run(self):
		gtk.gdk.threads_enter()
		self.logwindow.set_message(unicode(_('Sending %s Message...' % self.type), 'utf-8'))
		gtk.gdk.flush()
		gtk.gdk.threads_leave()

		if self.client.vote_message(self.mid, self.type):
			gtk.gdk.threads_enter()
			self.logwindow.add_message(unicode(_('failed!!'), 'utf-8'))
			open_error_dialog(self.client.headers["ExtraMessage"], self.logwindow.window)
			gtk.gdk.flush()
			gtk.gdk.threads_leave()
		else:
			gtk.gdk.threads_enter()
			self.logwindow.add_message(unicode(_('Done.'), 'utf-8'))
			gtk.gdk.flush()
			gtk.gdk.threads_leave()


class MessageSender(Thread):
	def __init__(self, app, client, auto_clear, logging, channel, script, ghost):
		self.app        = app
		self.client     = client
		self.auto_clear = auto_clear
		self.logging    = logging
		self.channel    = channel
		self.script     = script
		self.ghost      = ghost
		self.logpath    = os.path.join(open_bottlecase(), 'sent.log')
		Thread.__init__(self)

	def run(self):
		self.send()

	def send(self):
		gtk.gdk.threads_enter()
		self.app.monitor_clear()
		self.app.monitor_insert(unicode(_("Broadcasting..."), "utf-8"))
		gtk.gdk.flush()
		gtk.gdk.threads_leave()

		try:
			if self.client.send_broadcast(self.channel, self.script, self.ghost):
				error = self.client.headers["ExtraMessage"]
			else:
				error = None
		except BottleClientError, e:
			error = str(e)

		if error is not None:
			gtk.gdk.threads_enter()
			open_error_dialog(unicode(_("failed!!")) + "\n" + \
							  unicode(_("Error"), "utf8") + ": \n" + \
							  unicode(error), self.app.window)
			gtk.gdk.flush()
			gtk.gdk.threads_leave()

		else:
			if not self.sent_log():
				gtk.gdk.threads_enter()
				open_error_dialog(unicode(_('Failed to write sent log'), 'utf-8'),
								  self.app.window)
				gtk.gdk.flush()
				gtk.gdk.threads_leave()

			if self.auto_clear:
				gtk.gdk.threads_enter()
				self.app.edit_clear()
				gtk.gdk.flush()
				gtk.gdk.threads_leave()

		gtk.gdk.threads_enter()
		self.app.pbar.set_fraction(0.0)
		gtk.gdk.flush()
		gtk.gdk.threads_leave()

	def sent_log(self):
		if not self.logging:
			return True

		now     = time.strftime("%Y/%m/%d-%H:%M:%S", time.localtime(time.time()))
		channel = self.client.channels[self.channel]["name"]
		line    = "%s\t%s\t%s\t%s\n" % (now, self.ghost, channel, self.script)

		# lock start
		if os.name == 'posix':
			lockfunc   = lambda file, filename: fcntl.flock(file.fileno(), fcntl.LOCK_EX|fcntl.LOCK_NB)
			unlockfunc = lambda file, filename: fcntl.flock(file.fileno(), fcntl.LOCK_UN)
		else:
			lockfunc   = lambda file, filename: msvcrt.locking(file.fileno(), msvcrt.LK_NBLCK,
															   os.path.getsize(filename))
			unlockfunc = lambda file, filename: msvcrt.locking(file.fileno(), msvcrt.LK_UNLCK,
															   os.path.getsize(filename))
		count = 5
		lockfilename = os.path.join(open_bottlecase(), '.sentloglock')
		lockfile = open(lockfilename, 'w')
		while True:
			try:
				lockfunc(lockfile, lockfilename)
			except IOError:
				if count <= 0:
					return False
				count -= 1
				sys.stderr.write('%s is locked, sleep a second\n' % self.logpath)
				time.sleep(1)
			else:
				break
		# lock end

		try:
			file = open(self.logpath, 'a')
		except IOError, (errno, message):
			unlockfunc(lockfile, lockfilename)
			return False
		else:
			file.write(line)
			file.close()

		unlockfunc(lockfile, lockfilename)
		return True
