# -*- coding: ascii -*-
#
#  logmanager.py - Log Management part of LogWindow
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: logmanager.py,v 1.2 2004/09/21 11:48:35 atzm Exp $
#

import gtk
import os
from threading import Thread
from types     import *

from xmllogger  import XMLLogger
from logfetcher import LogFetcher
from common     import *

class XMLLogWriter(Thread):
	def __init__(self, logwindow, loglist, filename, compress, display=False):
		self.logwindow = logwindow
		self.loglist   = loglist
		self.filename  = filename
		self.display   = display
		self.logger    = XMLLogger(compress)
		Thread.__init__(self)

	def action(self, func):
		if self.display:
			gtk.gdk.threads_enter()
			func(None)
			gtk.gdk.flush()
			gtk.gdk.threads_leave()

	def run(self):
		self.action(lambda x: self.logwindow.set_message(unicode(_('Now reading list...'), 'utf-8')))
		lines = self.loglist.get_plain_array()

		self.action(lambda x: self.logwindow.set_message(unicode(_('Done.'), 'utf-8') + ' ' + \
														 unicode(_('Now writing log...'), 'utf-8')))
		res = self.logger.save_as_xml_from(lines, self.filename)

		if res:
			self.action(lambda x: self.logwindow.set_message(unicode(_('Done.'), 'utf-8')))
		else:
			self.action(lambda x: self.logwindow.set_message(unicode(_('failed!!'), 'utf-8')))

class XMLLogOpener(Thread):
	def __init__(self, logwindow, filename, logtabfocus, logpagepos):
		self.logwindow   = logwindow
		self.filename    = filename
		self.logtabfocus = logtabfocus
		self.logpagepos  = logpagepos
		self.logger      = XMLLogger()
		Thread.__init__(self)

	def action(self, func):
		gtk.gdk.threads_enter()
		func(None)
		gtk.gdk.flush()
		gtk.gdk.threads_leave()

	def run(self):
		self.action(lambda x: self.logwindow.set_message(unicode(_('Now reading log...'), 'utf-8')))

		logs = self.logger.open_xml_from(self.filename)
		if logs == -1:
			self.action(lambda x: self.logwindow.set_message(unicode(_('failed!!'), 'utf-8')))
			self.action(lambda x: open_error_dialog(unicode(_("Can't open file"), 'utf-8') + " '%s' " %
													self.filename,
													self.logwindow.window))
		else:
			self.action(lambda x: self.logwindow.set_message(unicode(_('Done.'), 'utf-8') + ' ' + \
												   unicode(_('Now building lists...'), 'utf-8')))
			self.action(lambda x: self.logwindow.create_tab(os.path.basename(self.filename),
															list=logs,
															focus=self.logtabfocus,
															pos=self.logpagepos))
			self.action(lambda x: self.logwindow.set_message(' ' + unicode(_('Done.'), 'utf-8')))

class LogFetchOperator(Thread):
	def __init__(self, logwindow, request, request_name, logtabfocus, logpagepos):
		self.logwindow    = logwindow
		self.request      = request
		self.request_name = request_name
		self.logtabfocus  = logtabfocus
		self.logpagepos   = logpagepos
		self.fetcher      = LogFetcher()
		Thread.__init__(self)

	def run(self):
		gtk.gdk.threads_enter()
		self.logwindow.set_message(unicode(_('Now fetching log...'), 'utf-8'))
		gtk.gdk.flush()
		gtk.gdk.threads_leave()

		logs = self.fetcher.fetch(self.request)

		if type(logs) is StringType:
			gtk.gdk.threads_enter()
			self.logwindow.set_message(unicode(_('failed!!'), 'utf-8'))
			open_error_dialog(unicode(_('Server returns some errors'), 'utf-8') + \
							  ':\n   ' + logs, self.logwindow.window)
			gtk.gdk.flush()
			gtk.gdk.threads_leave()
		else:
			gtk.gdk.threads_enter()
			self.logwindow.set_message(unicode(_('Done.'), 'utf-8') + ' ' + \
									   unicode(_('Now building lists...'), 'utf-8'))
			gtk.gdk.flush()
			gtk.gdk.threads_leave()

			gtk.gdk.threads_enter()
			self.logwindow.create_tab(self.request_name, list=logs,
									  focus=self.logtabfocus,
									  pos=self.logpagepos)
			self.logwindow.set_message(' ' + unicode(_('Done.'), 'utf-8'))
			gtk.gdk.flush()
			gtk.gdk.threads_leave()
