// GBAEmuDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBAEmu.h"
#include "GBAEmuDlg.h"
#include "RegDlg.h"

CGBAEmuDlg	GBAEmu;
void InitializeVideo(HDC hDC);

#include "defines.h"
#define	_GBAEMU_
ARM7TDMI arm;
u8	SystemRom[0x4000];
u8	ExWorkRam[0x40000];
u8	InWorkRam[0x8000];
u8	IoRam[0x400];
u8	PaletteRam[0x400];
u8	VRam[0x18000];
u8	Oam[0x400];
u8	Rom[0x40000];
bool fRegDlg=false;
u8	fBreak=0x00;

#include "memory.c"
#include "opcode_arm.c"
#include "opcode_thumb.c"
#include "mainloop.c"
bool CPUIsRunning;
RECT DlgSize;
u16	FrameBuffer[240*160];
DWORD dwSize = sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD)*256;
typedef struct{
	BITMAPINFOHEADER	bmiHeader;
	RGBQUAD				bmiColors[256];
}BMPINFO;
BMPINFO bmp_info;
HDC	hMemDC;		// obNobt@(rbg}bv)쐬
HDC hDC;		// LCDp̃foCXReLXg
HBITMAP	hBitmap=NULL;
u8	*pBitmap;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGBAEmuDlg _CAO

CGBAEmuDlg::CGBAEmuDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGBAEmuDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGBAEmuDlg)
		// : ̈ʒu ClassWizard ɂăȍǉ܂B
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	
	m_pTMain=NULL;
	m_pRegDlg=NULL;
}

void CGBAEmuDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGBAEmuDlg)
		// : ̏ꏊɂ ClassWizard ɂ DDX  DDV ̌Ăяoǉ܂B
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGBAEmuDlg, CDialog)
	//{{AFX_MSG_MAP(CGBAEmuDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_SIZE()
	ON_COMMAND(ID_MENU_OPEN, OnMenuOpen)
	ON_COMMAND(ID_MENU_EXIT, OnMenuExit)
	ON_COMMAND(ID_MENU_ABOUT, OnMenuAbout)
	ON_COMMAND(ID_MENU_RESET, OnMenuReset)
	ON_COMMAND(ID_MENU_REGISTERS, OnMenuRegisters)
	ON_WM_ACTIVATE()
	ON_COMMAND(ID_MENU_RUN, OnMenuRun)
	ON_COMMAND(ID_MENU_NEXT, OnMenuNext)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGBAEmuDlg bZ[W nh

BOOL CGBAEmuDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	SetIcon(m_hIcon, FALSE);		// ACRݒ

	hDC = ::GetDC(m_hWnd);
	InitializeVideo(hDC);
	::ReleaseDC(m_hWnd, hDC);

	SetRect(&DlgSize, 0, 0, LCD_X-2, LCD_Y-2);
	AdjustWindowRect(&DlgSize, WS_OVERLAPPEDWINDOW, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	InitializeRegister();
	OnMenuOpen();
	
	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CGBAEmuDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();

		LCDDraw();
	}
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR CGBAEmuDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void InitializeVideo(HDC hDC)
{	/*rbg}bv*/

	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= LCD_X;
	bmp_info.bmiHeader.biHeight		= -LCD_Y;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 16;

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
}

void CGBAEmuDlg::LCDDraw()
{
//	memcpy(pBitmap, FrameBuffer, LCD_X * LCD_Y);
	memcpy(pBitmap, VRam, LCD_X * LCD_Y);
	hDC = ::GetDC(m_hWnd);
	::StretchBlt(hDC, 0, 0, DlgSize.right, DlgSize.bottom, hMemDC,
					0, 0, LCD_X, LCD_Y, SRCCOPY);
	::ReleaseDC(m_hWnd, hDC);
}

void CGBAEmuDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	GetClientRect(&DlgSize);
}

void CGBAEmuDlg::OnMenuOpen()
{
	FILE*	fp;
	OPENFILENAME ofn;
	char filename[512];

	memset(filename, 0, 512);
	memset(&ofn, 0, sizeof(ofn));
	ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrFile = filename;
	ofn.lpstrFilter = "GameboyAdvance ROM Files (*.gba;*.bin)\0*.gba;*.bin\0All Files (*.*)\0*.*";
	ofn.nMaxFileTitle = 512;
	ofn.nMaxFile = 512;
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = m_hWnd;

	if(GetOpenFileName(&ofn)){
		fp = fopen(filename ,"rb");
		fread(Rom, 1, 0x40000, fp);
	}
	OnMenuRegisters();
}

void CGBAEmuDlg::OnMenuExit() 
{
	DestroyWindow();
}

void CGBAEmuDlg::OnMenuAbout() 
{
	MessageBox("Copyright by Y_N\nhttps://sourceforge.jp/projects/gbemu/", NULL, MB_OK);
}

void CGBAEmuDlg::OnMenuReset() 
{
	InitializeMemory();
	InitializeRegister();
}

void CGBAEmuDlg::OnMenuRun() 
{
	CPUIsRunning=true;
	m_pTMain = AfxBeginThread(ThreadMain, this);
}

void CGBAEmuDlg::OnMenuNext() 
{
	fBreak=1;
	AfxGetMainWnd()->SendMessage(WM_ACTIVATE, 0, 0);
	if(fRegDlg)m_pRegDlg->ShowRegisters();
}

void DrawLine()
{

}

UINT CGBAEmuDlg::ThreadMain(LPVOID pParam)
{
	((CGBAEmuDlg*)pParam)->MainLoop();

	return 0;
}

void CGBAEmuDlg::OnMenuRegisters()
{
	if(!fRegDlg){
		if(m_pRegDlg==NULL){
			m_pRegDlg = new CRegDlg;
			m_pRegDlg->Create(IDD_REGISTERS_DIALOG);
		}
		m_pRegDlg->ShowWindow(SW_SHOW);
		fRegDlg=true;
	}
	else m_pRegDlg->SetFocus();

	m_pRegDlg->ShowRegisters();
}

void CGBAEmuDlg::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{
	CDialog::OnActivate(nState, pWndOther, bMinimized);
	
	if(fBreak){
		fBreak=0;
		CPUIsRunning=false;
		MainLoop();
		if(fRegDlg)m_pRegDlg->ShowRegisters();
	}
}

BOOL CGBAEmuDlg::PreTranslateMessage(MSG* pMsg) 
{
/*	if(pMsg->message==WM_KEYDOWN){
		if(pMsg->wParam==VK_RETURN){
			return FALSE;
		}
		else if(pMsg->wParam==VK_ESCAPE){
			return FALSE;
		}
	}*/

	return CDialog::PreTranslateMessage(pMsg);
}

void CDialog::OnOK(){}

void CGBAEmuDlg::ShowMnimonic(char* mnimonic)
{
	m_pRegDlg->m_txtMnimonic=mnimonic;
}
